/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.ws;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;

public class SOAPFaultTracer
extends ASingleMetricTracerFactory {
    String objString = null;

    public SOAPFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Method M_Attribute;
            Object xiNodeObj;
            Object xiNodeObject;
            String component = this.formatParameterizedResource(data);
            this.getAgent().IAgent_getComponentTracer().removeComponent(component);
            Object invObj = data.getInvocationObject();
            if (invObj != null && (xiNodeObject = data.getInvocationParameterAsObject(0)) != null && (xiNodeObj = (M_Attribute = TibcoReflectionCache.getM_Attribute_getStringValue(xiNodeObject)).invoke(xiNodeObject, KConstants.EMPTY_OBJECT_ARRAY)) != null) {
                this.objString = (String)xiNodeObj;
            }
            if (this.objString != null) {
                String errorMessage = "SOAP Fault: " + component + ": " + this.objString;
                if (isDebugEnabled) {
                    TibcoBWUtils.getLogger().debug("SOAP Fault Message: " + errorMessage);
                }
                if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                }
            }
            String name = this.formatParameterizedName(data);
            this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
        catch (ESEException eSEException) {
            Assertion.wilyFail((String)"Metric type conflict");
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_SOAPFAULTTRACER", bomb);
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        String component = this.formatParameterizedResource(data);
        this.getAgent().IAgent_getComponentTracer().addComponent(component);
    }

    public boolean ITracerFactory_isShutoff() {
        return super.ITracerFactory_isShutoff();
    }

    protected IDataAccumulator createDataAccumulator(String s) {
        return null;
    }
}

