/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Set;

public class FrontendTracer
extends BlamePointTracer {
    private static final String kIsFrontendUnless = "is.frontend.unless";
    private Set fIsFrontendUnless;
    private static final String kFrontendsCategoryPrefix = "Frontends|";
    private boolean isSkippedClass = false;
    private final boolean fCheck;

    public FrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String isFrontendUnless = this.getParameter(kIsFrontendUnless);
        this.fCheck = this.calculateBooleanParameter("checkfrontend", true);
        this.fIsFrontendUnless = StringUtils.parseAndTrimListToSet(isFrontendUnless, ",");
    }

    protected Set getClassesToSkip() {
        return this.fIsFrontendUnless;
    }

    protected void setSkippedClass() {
        this.isSkippedClass = true;
    }

    protected boolean isSkippedClass() {
        return this.isSkippedClass;
    }

    protected boolean hasFrontend() {
        return VirtualStack.staticHasFrontBoundary();
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return kFrontendsCategoryPrefix + rootName;
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String name = super.formatParameterizedName(data);
        if (!name.contains("Frontends")) {
            name = this.getFrontendNameForComponent(name);
        }
        return name;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String className;
        Object invocationObject = data.getInvocationObject();
        String string = className = invocationObject == null ? data.getProbeInformation().getProbeIdentification().getProbeClassName() : invocationObject.getClass().getName();
        if (this.getClassesToSkip().contains(className)) {
            this.isSkippedClass = true;
            return;
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.isDisabled()) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.fCheck && this.hasFrontend();
    }

    protected boolean isDisabled() {
        return this.isSkippedClass;
    }

    @Override
    protected final boolean hasContextualMetrics() {
        return true;
    }

    @Override
    protected boolean subscribeToDownstreamErrors() {
        return true;
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setLastFrontendCursor(element);
        super.doOnStartTrace(tracerIndex, elementData, element);
        data.setFrontBoundary(tracerIndex);
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        super.doOnEndTrace(tracerIndex, elementData, element);
        data.unsetFrontBoundary(tracerIndex);
    }

    @Override
    protected boolean subscribeToDownstreamStalls() {
        return true;
    }

    @Override
    protected AgentMetric[] createTimerMetric(String formattedMetricName) {
        int metricType = 0x10000401;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createPerIntervalMetric(String formattedMetricName) {
        int metricType = 0x10002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 0x10000101;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createErrorsMetric(String formattedMetricName) {
        int metricType = 0x10002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createStallsMetric(String formattedMetricName) {
        int metricType = 0x10000181;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected int getBlameStatus() {
        return 1;
    }

    @Override
    public boolean canCacheTracerInstances() {
        return false;
    }
}

