/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.servlet.BytecodeClassLoader;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class ServletHelperFactory {
    private static final IWeakIdentityMap repository = ServletHelperFactory.getCache("ServletHelpers");
    static volatile Class helperClass;
    static volatile ClassLoader helperClassLoader;
    static volatile String[] helperClasses;
    static volatile IServletRequestHelper helperForSystemLoader;

    private static final IWeakIdentityMap getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory mapFactory = agent.IAgent_getConcurrentMapFactory();
            return mapFactory.getConcurrentCappedWeakIdentityMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    public static IServletRequestHelper getServletHelper(ClassLoader loader, IModuleFeedbackChannel feedback) {
        boolean useSystemLoader = loader == null;
        IServletRequestHelper result = null;
        result = useSystemLoader ? helperForSystemLoader : (IServletRequestHelper)repository.getWeak(loader);
        if (result == null) {
            Object helper = null;
            try {
                BytecodeClassLoader newClassLoader = new BytecodeClassLoader(useSystemLoader ? ClassLoader.getSystemClassLoader() : loader, helperClassLoader, helperClasses, feedback);
                Class<?> cachedClassLoaderClass = Class.forName(helperClass.getName(), true, newClassLoader);
                helper = cachedClassLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (helper != null) {
                result = helper;
                result.setFeedback(feedback);
            }
            if (useSystemLoader) {
                helperForSystemLoader = result;
            } else {
                IServletRequestHelper existingHelper = (IServletRequestHelper)repository.putWeak(loader, result);
                if (existingHelper != null) {
                    result = existingHelper;
                }
            }
        }
        return result;
    }

    public static void setHelperClass(Class class1) {
        helperClass = class1;
        helperClassLoader = class1.getClassLoader();
    }

    public static void setHelperClasses(String[] class1) {
        helperClasses = class1;
    }
}

