/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ApplicationHelper;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ApplicationUIHelper {
    public static void handleLaunchFailure(String[] messages, boolean useUI) {
        if (useUI) {
            ApplicationUIHelper.showDialog(messages);
        }
        ApplicationHelper.printToConsole(messages);
        if (!useUI) {
            System.exit(1);
        }
    }

    private static void showDialog(String[] messages) {
        DialogFrame dialog = new DialogFrame(messages);
        dialog.setVisible(true);
    }

    private static class DialogFrame
    extends Frame {
        private static final long serialVersionUID = -831288770640661754L;
        private Button fButton;
        private static int kRows = 15;
        private static int kColumns = 60;

        public DialogFrame(String[] messages) {
            super("Error");
            this.setLayout(new BorderLayout());
            TextArea text = new TextArea("", kRows, kColumns, 1);
            text.setEditable(false);
            int i = 0;
            while (i < messages.length) {
                text.append(messages[i]);
                if (i != messages.length - 1) {
                    text.append("\n\n");
                }
                ++i;
            }
            this.add((Component)text, "Center");
            this.fButton = new Button("Ok");
            Panel panel = new Panel(new FlowLayout());
            panel.add(this.fButton);
            this.add((Component)panel, "South");
            this.pack();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenDimension = toolkit.getScreenSize();
            Dimension frameDimension = this.getSize();
            double frameX = screenDimension.width / 2 - frameDimension.width / 2;
            double frameY = screenDimension.height / 2 - frameDimension.width / 2;
            this.setLocation((int)frameX, (int)frameY);
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ DialogFrame this$1;
                {
                    this.this$1 = dialogFrame;
                }

                public void windowClosing(WindowEvent e) {
                    this.this$1.setVisible(false);
                    this.this$1.dispose();
                    System.exit(1);
                }
            });
            this.fButton.addActionListener(new ActionListener(this){
                final /* synthetic */ DialogFrame this$1;
                {
                    this.this$1 = dialogFrame;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setVisible(false);
                    this.this$1.dispose();
                    System.exit(1);
                }
            });
        }
    }
}

