/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Latch;
import com.wily.util.HashCodeUtils;
import com.wily.util.IComparer;
import com.wily.util.adt.BlockingQueue;
import com.wily.util.adt.PriorityQueue;
import com.wily.util.event.AListenerEvent;
import com.wily.util.event.DefaultStableEventMarkerTracker;
import com.wily.util.event.EventMarker;
import com.wily.util.event.EventMarkerGenerator;
import com.wily.util.event.IEventMarkedRunnable;
import com.wily.util.event.IStableEventMarkerTracker;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ITrackableListenerAllListeners;
import com.wily.util.event.ListenerTracker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public final class EventPump {
    private final EventMarkerGenerator fEventMarkerGenerator;
    private final IStableEventMarkerTracker fStableEventMarkerTracker;
    private final DeathWatchTable fDeathWatchTable;
    private final EventPumpThread fPumpThread;
    private final IModuleFeedbackChannel fFeedback;
    private final BlockingQueue fMasterQueue;
    private final PriorityQueue fSlaveQueue;
    private PrintWriter fLog;

    public EventPump(String name, IModuleFeedbackChannel feedback) {
        this(name, feedback, new EventMarkerGenerator(), new DefaultStableEventMarkerTracker());
    }

    public EventPump(String name, IModuleFeedbackChannel feedback, IStableEventMarkerTracker stableEventMarkerTracker) {
        this(name, feedback, new EventMarkerGenerator(), stableEventMarkerTracker);
    }

    public EventPump(String name, IModuleFeedbackChannel feedback, EventMarkerGenerator eventMarkerGenerator, IStableEventMarkerTracker stableEventMarkerTracker) {
        this.fEventMarkerGenerator = eventMarkerGenerator;
        this.fStableEventMarkerTracker = stableEventMarkerTracker;
        this.fFeedback = feedback;
        this.fDeathWatchTable = new DeathWatchTable();
        this.fSlaveQueue = new PriorityQueue(new PostingComparer());
        this.fMasterQueue = new BlockingQueue("master event queue", feedback);
        this.fPumpThread = new EventPumpThread(name);
        this.getStableEventMarkerTracker().IStableEventMarkerTracker_setInitialEventMarker(this.getEventMarkerGenerator().getFirstEventMarker());
        this.fPumpThread.start();
    }

    public void close() {
        try {
            this.fPumpThread.interrupt();
            this.fPumpThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private EventMarkerGenerator getEventMarkerGenerator() {
        return this.fEventMarkerGenerator;
    }

    private IStableEventMarkerTracker getStableEventMarkerTracker() {
        return this.fStableEventMarkerTracker;
    }

    public String getName() {
        return this.fPumpThread.getName();
    }

    public boolean isEventPumpThread() {
        return Thread.currentThread() == this.fPumpThread;
    }

    private void immediateDeliverBroadcastEventAsync(ListenerTracker tracker, AListenerEvent event) {
        ITrackableListener[] listeners = tracker.getBroadcastListenerSnapshot();
        for (int i = listeners.length - 1; i >= 0; --i) {
            this.immediateDeliverEventIfListenerNotDead(tracker, listeners[i], event);
        }
        this.getStableEventMarkerTracker().IStableEventMarkerTracker_noticeCompletedEvent(event);
    }

    private void immediateDeliverTargetEventAsync(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent event) {
        this.immediateDeliverEventIfListenerNotDead(tracker, specificListener, event);
        this.getStableEventMarkerTracker().IStableEventMarkerTracker_noticeCompletedEvent(event);
    }

    private void immediateDeliverEventIfListenerNotDead(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent event) {
        Assertion.wilyAssert(specificListener != null);
        Assertion.wilyAssert(!(specificListener instanceof ITrackableListenerAllListeners));
        if (!this.fDeathWatchTable.isDead(tracker, specificListener)) {
            tracker.sendEventToOneListener(specificListener, event);
        }
    }

    private void immediateAddBroadcastListener(ListenerTracker tracker, ITrackableListener specificListener) {
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        Assertion.wilyAssert(!tracker.isListener(specificListener), "Illegal add for Listener");
        tracker.addBroadcastListener(specificListener);
    }

    private void immediateRemoveBroadcastListener(ListenerTracker tracker, ITrackableListener specificListener) {
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        tracker.removeBroadcastListener(specificListener);
    }

    private void immediateRun(EventMarker eventMarker, IEventMarkedRunnable runnable) {
        Assertion.wilyAssert(runnable != null);
        runnable.IEventMarkedRunnable_run(eventMarker);
    }

    public synchronized void postBroadcastEvent(ListenerTracker tracker, AListenerEvent event) {
        this.postTargetedEvent(tracker, ListenerTracker.kBroadcastToAllListeners, event);
    }

    public synchronized void postTargetedEvent(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent event) {
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        event.setEventMarker(this.getEventMarkerGenerator().generateMasterEventMarker());
        this.post(new Posting(tracker, specificListener, event));
    }

    public synchronized EventMarker postBroadcastSlaveEvent(ListenerTracker tracker, AListenerEvent event) {
        return this.postTargetedSlaveEvent(tracker, ListenerTracker.kBroadcastToAllListeners, event);
    }

    public synchronized EventMarker postTargetedSlaveEvent(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent event) {
        Assertion.wilyAssert(this.isEventPumpThread(), "Slave events can only be posted from the event pump thread itself");
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        EventMarker marker = this.getEventMarkerGenerator().generateSlaveEventMarker(this.fPumpThread.getCurrentEventMarker());
        event.setEventMarker(marker);
        this.postSlave(new Posting(tracker, specificListener, event));
        return marker;
    }

    public void postAddBroadcastListener(ListenerTracker tracker, ITrackableListener specificListener) {
        this.postAddBroadcastListener(tracker, specificListener, null);
    }

    public synchronized void postAddBroadcastListener(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent notificationEvent) {
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        EventMarker addListenerMarker = this.getEventMarkerGenerator().generateMasterEventMarker();
        if (notificationEvent != null) {
            notificationEvent.setEventMarker(this.getEventMarkerGenerator().generateSlaveEventMarker(addListenerMarker));
        }
        this.post(new Posting(5, tracker, specificListener, notificationEvent, addListenerMarker));
    }

    public synchronized void postRemoveBroadcastListener(ListenerTracker tracker, ITrackableListener specificListener) {
        Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
        this.fDeathWatchTable.incrementDeathWatchCounter(tracker, specificListener);
        this.post(new Posting(6, tracker, specificListener, null, this.getEventMarkerGenerator().generateMasterEventMarker()));
    }

    public synchronized void invokeLater(IEventMarkedRunnable runnable) {
        Assertion.wilyAssert(runnable != null);
        this.post(new Posting(runnable, this.getEventMarkerGenerator().generateMasterEventMarker()));
    }

    public EventMarker getLastStableEventMarker() {
        return this.getStableEventMarkerTracker().IStableEventMarkerTracker_getLastStableEventMarker();
    }

    public void addStableEventMarkerChangeLatch(EventMarker marker, Latch latch) {
        this.getStableEventMarkerTracker().IStableEventMarkerTracker_addStableEventMarkerChangeLatch(marker, latch);
    }

    public void setLog(PrintWriter log) {
        this.fLog = log;
        this.getLog().println("initializing log for EventPump: " + this.getName());
    }

    private boolean loggingEnabled() {
        return this.fLog != null;
    }

    private PrintWriter getLog() {
        return this.fLog;
    }

    private Posting getNextPosting() throws InterruptedException {
        if (!this.fSlaveQueue.isEmpty()) {
            return (Posting)this.fSlaveQueue.dequeue();
        }
        return (Posting)this.fMasterQueue.dequeue();
    }

    private void post(Posting newPosting) {
        this.fMasterQueue.enqueue(newPosting);
    }

    private void postSlave(Posting newPosting) {
        this.fSlaveQueue.insert(newPosting);
    }

    private final class EventPumpThread
    extends Thread {
        private Posting fCurrentPosting;

        public EventPumpThread(String name) {
            super(name);
            this.setDaemon(true);
            this.fCurrentPosting = null;
        }

        public EventMarker getCurrentEventMarker() {
            Assertion.wilyAssert(Thread.currentThread() == this);
            if (this.fCurrentPosting != null) {
                return this.fCurrentPosting.getEventMarker();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    this.fCurrentPosting = EventPump.this.getNextPosting();
                    this.fCurrentPosting.deliver();
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable t) {
                    EventPump.this.getModuleFeedback().error(t);
                    continue;
                }
                finally {
                    this.fCurrentPosting = null;
                    continue;
                }
                break;
            }
        }
    }

    private class TrackerListenerPairKey {
        private ListenerTracker fListenerTracker;
        private ITrackableListener fTrackableListener;

        public TrackerListenerPairKey(ListenerTracker tracker, ITrackableListener listener) {
            Assertion.wilyAssert(tracker != null && listener != null);
            this.fListenerTracker = tracker;
            this.fTrackableListener = listener;
        }

        public boolean equals(Object obj) {
            TrackerListenerPairKey candidate = (TrackerListenerPairKey)obj;
            return candidate.fListenerTracker == this.fListenerTracker && candidate.fTrackableListener == this.fTrackableListener;
        }

        public int hashCode() {
            int hash = 17;
            hash = HashCodeUtils.accumulateHashCode(hash, this.fListenerTracker.hashCode());
            hash = HashCodeUtils.accumulateHashCode(hash, this.fTrackableListener.hashCode());
            return hash;
        }
    }

    private final class DeathWatchTable {
        private final Map fDeathCountMap = new HashMap();

        public synchronized void incrementDeathWatchCounter(ListenerTracker tracker, ITrackableListener listener) {
            TrackerListenerPairKey key = new TrackerListenerPairKey(tracker, listener);
            Integer deathCount = (Integer)this.fDeathCountMap.get(key);
            deathCount = deathCount == null ? new Integer(1) : new Integer(deathCount + 1);
            this.fDeathCountMap.put(key, deathCount);
        }

        public synchronized void decrementDeathWatchCounter(ListenerTracker tracker, ITrackableListener listener) {
            TrackerListenerPairKey key = new TrackerListenerPairKey(tracker, listener);
            Integer deathCount = (Integer)this.fDeathCountMap.get(key);
            Assertion.wilyAssert(deathCount != null, "death count cannot be negative");
            int intDeathCount = deathCount;
            if (intDeathCount == 1) {
                this.fDeathCountMap.remove(key);
            } else {
                this.fDeathCountMap.put(key, new Integer(intDeathCount - 1));
            }
        }

        public synchronized boolean isDead(ListenerTracker tracker, ITrackableListener listener) {
            TrackerListenerPairKey key = new TrackerListenerPairKey(tracker, listener);
            Object deathCount = this.fDeathCountMap.get(key);
            return deathCount != null;
        }
    }

    private final class Posting {
        public static final int kPostingAdd = 5;
        public static final int kPostingRemove = 6;
        private static final int kPostingEvent = 4;
        private static final int kPostingInvokeLater = 7;
        private final int fCode;
        private final ListenerTracker fTargetListeners;
        private final ITrackableListener fSpecificListener;
        private final AListenerEvent fEvent;
        private final IEventMarkedRunnable fRunnable;
        private final EventMarker fEventMarker;

        public Posting(ListenerTracker tracker, AListenerEvent event) {
            this.fCode = 4;
            this.fTargetListeners = tracker;
            this.fSpecificListener = null;
            this.fEvent = event;
            this.fRunnable = null;
            this.fEventMarker = null;
        }

        public Posting(ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent event) {
            Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
            this.fCode = 4;
            this.fTargetListeners = tracker;
            this.fSpecificListener = specificListener;
            this.fEvent = event;
            this.fRunnable = null;
            this.fEventMarker = null;
        }

        public Posting(int op, ListenerTracker tracker, ITrackableListener specificListener, AListenerEvent notificationEvent, EventMarker postingMarker) {
            Assertion.wilyAssert(specificListener != null, "Listener is null, contact dhalem");
            this.fCode = op;
            this.fTargetListeners = tracker;
            this.fSpecificListener = specificListener;
            this.fEvent = notificationEvent;
            this.fRunnable = null;
            this.fEventMarker = postingMarker;
        }

        public Posting(IEventMarkedRunnable runnable, EventMarker postingMarker) {
            this.fCode = 7;
            this.fTargetListeners = null;
            this.fSpecificListener = null;
            this.fEvent = null;
            this.fRunnable = runnable;
            this.fEventMarker = postingMarker;
        }

        private AListenerEvent getEvent() {
            return this.fEvent;
        }

        public EventMarker getEventMarker() {
            Assertion.wilyAssert(this.fEvent != null || this.fEventMarker != null);
            if (this.getEvent() != null) {
                return this.getEvent().getEventMarker();
            }
            return this.fEventMarker;
        }

        public void deliver() {
            if (EventPump.this.loggingEnabled()) {
                PrintWriter log = EventPump.this.getLog();
                switch (this.fCode) {
                    case 4: {
                        log.println("[" + this.getEventMarker() + "] " + this.fEvent.toString());
                        break;
                    }
                    case 5: {
                        log.println("[" + this.getEventMarker() + "] adding new broadcast listener");
                        break;
                    }
                    case 6: {
                        log.println("[" + this.getEventMarker() + "] removing existing broadcast listener");
                        break;
                    }
                    case 7: {
                        log.println("[" + this.getEventMarker() + "] running " + this.fRunnable.toString());
                    }
                }
                this.fTargetListeners.debugLog(log);
            }
            switch (this.fCode) {
                case 4: {
                    if (this.fSpecificListener instanceof ITrackableListenerAllListeners) {
                        EventPump.this.immediateDeliverBroadcastEventAsync(this.fTargetListeners, this.fEvent);
                        break;
                    }
                    if (EventPump.this.fDeathWatchTable.isDead(this.fTargetListeners, this.fSpecificListener)) break;
                    EventPump.this.immediateDeliverTargetEventAsync(this.fTargetListeners, this.fSpecificListener, this.fEvent);
                    break;
                }
                case 5: {
                    if (EventPump.this.fDeathWatchTable.isDead(this.fTargetListeners, this.fSpecificListener)) break;
                    EventPump.this.immediateAddBroadcastListener(this.fTargetListeners, this.fSpecificListener);
                    if (this.getEvent() == null) break;
                    EventPump.this.immediateDeliverTargetEventAsync(this.fTargetListeners, this.fSpecificListener, this.getEvent());
                    break;
                }
                case 6: {
                    EventPump.this.fDeathWatchTable.decrementDeathWatchCounter(this.fTargetListeners, this.fSpecificListener);
                    EventPump.this.immediateRemoveBroadcastListener(this.fTargetListeners, this.fSpecificListener);
                    break;
                }
                case 7: {
                    EventPump.this.immediateRun(this.getEventMarker(), this.fRunnable);
                }
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("[");
            result.append(this.getEventMarker().toString());
            result.append("] ");
            switch (this.fCode) {
                case 5: {
                    result.append("kPostingAdd: ");
                    if (this.fSpecificListener == null) {
                        result.append("<null>");
                        break;
                    }
                    result.append(this.fSpecificListener.toString());
                    break;
                }
                case 6: {
                    result.append("kPostingRemove");
                    if (this.fSpecificListener == null) {
                        result.append("<null>");
                        break;
                    }
                    result.append(this.fSpecificListener.toString());
                    break;
                }
                case 4: {
                    result.append("kPostingEvent: ");
                    if (this.fEvent == null) {
                        result.append("<null>");
                        break;
                    }
                    result.append(this.fEvent.toString());
                    break;
                }
                case 7: {
                    result.append(this.fRunnable.toString());
                    break;
                }
                default: {
                    result.append("!!unknown posting code!!");
                }
            }
            return result.toString();
        }
    }

    private final class PostingComparer
    implements IComparer {
        private PostingComparer() {
        }

        public boolean lessThan(Object obj1, Object obj2) {
            Posting posting1 = (Posting)obj1;
            Posting posting2 = (Posting)obj2;
            return posting1.getEventMarker().compareTo(posting2.getEventMarker()) < 0;
        }

        public boolean equalTo(Object obj1, Object obj2) {
            Posting posting1 = (Posting)obj1;
            Posting posting2 = (Posting)obj2;
            return posting1.getEventMarker().compareTo(posting2.getEventMarker()) == 0;
        }
    }
}

