/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.KConstants;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

public class ApacheHttpComponentsClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("Apache HTTP Components Client Data Resolver");
    private static final HttpDataResolver instance = new ApacheHttpComponentsClientDataResolver();

    private ApacheHttpComponentsClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        try {
            Object req = this.getRequestObject(data);
            Object url = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getURI", (Class[])new Class[0], (Object[])new Object[0]);
            if (url == null) {
                return KConstants.UNKNOWN_URI;
            }
            if (url instanceof URI) {
                URI uri = (URI)url;
                if (!uri.isAbsolute()) {
                    Object params;
                    Object hostObject = this.getHostObject(data);
                    if (hostObject == null && (params = ReflectionUtils.invokeMethodOnObject((Object)req, (String)"getParams", (Class[])new Class[0], (Object[])new Object[0])) != null && (hostObject = this.resolveHostObject(params)) == null) {
                        params = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationObject(), (String)"getParams", (Class[])new Class[0], (Object[])new Object[0]);
                        hostObject = this.resolveHostObject(params);
                    }
                    if (hostObject != null) {
                        Object uriObj = ReflectionUtils.invokeMethodOnObject((Object)hostObject, (String)"toURI", (Class[])new Class[0], (Object[])new Object[0]);
                        if (uriObj != null) {
                            return URI.create(String.valueOf((String)uriObj) + uri.toString());
                        }
                    } else {
                        return KConstants.UNKNOWN_URI;
                    }
                }
                return uri;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getURI : Unable to get URL for Apache Http components client");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return KConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        try {
            Object httpMethod = ReflectionUtils.invokeMethodOnObject((Object)this.getRequestObject(data), (String)"getMethod", (Class[])new Class[0], (Object[])new Object[0]);
            if (httpMethod != null && httpMethod instanceof String) {
                return (String)httpMethod;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpMethod() : Unable to get HTTP method");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            Object statusLine = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationReturnValueAsObject(), (String)"getStatusLine", (Class[])new Class[0], (Object[])new Object[0]);
            if (statusLine != null) {
                Object responseCode = ReflectionUtils.invokeMethodOnObject((Object)statusLine, (String)"getStatusCode", (Class[])new Class[0], (Object[])new Object[0]);
                return (Integer)responseCode;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getStatusCode() : Unable to get http status code");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object statusLine = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationReturnValueAsObject(), (String)"getStatusLine", (Class[])new Class[0], (Object[])new Object[0]);
            if (statusLine != null) {
                Object reasonPhrase = ReflectionUtils.invokeMethodOnObject((Object)statusLine, (String)"getReasonPhrase", (Class[])new Class[0], (Object[])new Object[0]);
                return (String)reasonPhrase;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getReasonPhrase() : Unable to get http status message");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private Object getRequestObject(InvocationData data) {
        Object reqObj = data.getInvocationParameterAsObject(0);
        if (reqObj == null || reqObj.getClass().getName().equals("org.apache.http.HttpHost")) {
            reqObj = data.getInvocationParameterAsObject(1);
        }
        return reqObj;
    }

    private Object getHostObject(InvocationData data) {
        return data.getInvocationParameterAsObject(0);
    }

    private Object resolveHostObject(Object httpParams) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ReflectionUtils.invokeMethodOnObject((Object)httpParams, (String)"getParameter", (Class[])new Class[]{String.class}, (Object[])new String[]{"http.default-host"});
    }
}

