/*
 * Decompiled with CFR 0.152.
 */
package com.wily.persistence.perst;

import java.io.File;
import org.garret.perst.INamedClassLoader;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentMap;
import org.garret.perst.Storage;
import org.garret.perst.StorageFactory;

public class PerstHelper {
    private static Storage sStorage = StorageFactory.getInstance().createStorage();

    public static synchronized void setStorage(Storage mainDB) {
        sStorage = mainDB;
    }

    public static synchronized Storage getStorage(String dbFileName) {
        if (!sStorage.isOpened()) {
            String parentDirName;
            File dbFile = new File(dbFileName);
            if (!dbFile.exists() && (parentDirName = dbFile.getParent()) != null && !new File(parentDirName).exists()) {
                new File(parentDirName).mkdirs();
            }
            sStorage.open(dbFileName);
            if (sStorage.getRoot() == null) {
                sStorage.setRoot((IPersistent)sStorage.createMap(String.class));
                sStorage.commit();
            }
        }
        return sStorage;
    }

    private static IPersistentMap getRoot(String dbFileName) {
        return (IPersistentMap)PerstHelper.getStorage(dbFileName).getRoot();
    }

    public static void registerClassLoader(ClassLoader classLoader) {
        if (sStorage.isOpened()) {
            throw new IllegalStateException("getStorage() cannot be called before classloaders are registered");
        }
        if (!(classLoader instanceof INamedClassLoader)) {
            throw new IllegalArgumentException("Classloader must implement " + INamedClassLoader.class.getName());
        }
        sStorage.registerClassLoader((INamedClassLoader)classLoader);
    }

    public static synchronized Object getRootByKey(String dbFileName, String key) {
        return PerstHelper.getRoot(dbFileName).get((Object)key);
    }

    public static synchronized void createRootByKey(String dbFileName, String key, Object root) {
        PerstHelper.getRoot(dbFileName).put((Object)key, root);
    }

    static {
        sStorage.setProperty("perst.serialize.transient.objects", (Object)"true");
        sStorage.setProperty("perst.concurrent.iterator", (Object)"true");
        sStorage.setProperty("perst.alternative.btree", (Object)"true");
    }
}

