/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.dnd;

import com.wily.wilyassert.SwingAssertion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class DragBorder
extends LineBorder {
    private static final long serialVersionUID = -6991199080571598483L;
    private JComponent fContainingComponent;
    private boolean fHilite;
    private Border fOrigBorder;
    private Insets fBorderInsets;

    public DragBorder(JComponent containingComponent) {
        super(Color.blue, 2);
        this.fContainingComponent = containingComponent;
        this.fHilite = false;
        this.setupBorder(containingComponent);
    }

    private void setupBorder(JComponent containingComponent) {
        this.fOrigBorder = containingComponent.getBorder();
        this.fBorderInsets = new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        if (this.fOrigBorder != null) {
            Insets origBorderInsets = this.fOrigBorder.getBorderInsets(containingComponent);
            this.fBorderInsets.top = Math.max(this.fBorderInsets.top, origBorderInsets.top);
            this.fBorderInsets.left = Math.max(this.fBorderInsets.left, origBorderInsets.left);
            this.fBorderInsets.bottom = Math.max(this.fBorderInsets.bottom, origBorderInsets.bottom);
            this.fBorderInsets.right = Math.max(this.fBorderInsets.top, origBorderInsets.right);
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.fBorderInsets;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.fBorderInsets.top;
        insets.left = this.fBorderInsets.left;
        insets.bottom = this.fBorderInsets.bottom;
        insets.right = this.fBorderInsets.right;
        return insets;
    }

    public void hilite(boolean hilite) {
        SwingAssertion.assertSwingSafe(this.fContainingComponent);
        if (this.fHilite != hilite) {
            this.fHilite = hilite;
            this.fContainingComponent.getParent().validate();
            this.fContainingComponent.repaint();
        }
    }

    public boolean getHilite() {
        return this.fHilite;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.fOrigBorder != null) {
            this.fOrigBorder.paintBorder(c, g, x, y, width, height);
        }
        if (this.fHilite) {
            super.paintBorder(c, g, x, y, width, height);
        }
    }

    public String toString() {
        return "DragBorder: " + super.toString() + " fHilite: " + this.fHilite + " containingComp: " + this.fContainingComponent.getClass().getName();
    }
}

