/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.beans.bizrecording.EMBizRecordingCallbackWrapper;
import com.wily.isengard.messageprimitives.callback.Callback;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.Glob;
import com.wily.util.StringUtils;

class BizRecordingSession {
    private final IAgent fAgent;
    private final String fSessionId;
    private final String fIpFilter;
    private final String fLanguageFilter;
    private static final String kTimCompatibilityKey = "introscope.agent.bizRecording.timCompatible";
    private final boolean fUSeTimCompatibleMatching;
    private final Glob[] fLanguageGlobs;
    private final Glob fLanguageGlob;
    private final long fCreationTime;
    private final long fTimeout;
    private final EMBizRecordingCallbackWrapper fCallback;
    private CallbackConnector fConnector = null;
    static /* synthetic */ Class class$0;

    public BizRecordingSession(IAgent agent, String sessionId, String ipFilter, String languageFilter, long timeout, EMBizRecordingCallbackWrapper callback) {
        this.fAgent = agent;
        this.fSessionId = sessionId;
        this.fIpFilter = ipFilter;
        this.fLanguageFilter = languageFilter;
        this.fUSeTimCompatibleMatching = agent.IAgent_getIndexedProperties().getBooleanProperty(kTimCompatibilityKey, true);
        String[] globStrings = StringUtils.parseAndTrimList(languageFilter, ",", true);
        Glob[] globs = new Glob[globStrings.length];
        int i = 0;
        while (i < globStrings.length) {
            globs[i] = new Glob(globStrings[i]);
            ++i;
        }
        this.fLanguageGlobs = globs;
        this.fLanguageGlob = new Glob(languageFilter);
        this.fCreationTime = System.currentTimeMillis();
        this.fTimeout = timeout;
        this.fCallback = callback;
    }

    public String getSessionId() {
        return this.fSessionId;
    }

    public String getClientIpFilter() {
        return this.fIpFilter;
    }

    public String getLanguageFilter() {
        return this.fLanguageFilter;
    }

    public long getTimeout() {
        return this.fTimeout;
    }

    public long getCreationTime() {
        return this.fCreationTime;
    }

    public Callback getCallback() {
        return this.fCallback;
    }

    public CallbackConnector getConnector() {
        block6: {
            if (this.fConnector == null) {
                try {
                    ConnectedServer server;
                    IsengardServerConnectionManager connectionManager = this.fAgent.IAgent_getIsengardServerConnection();
                    if (connectionManager == null || (server = connectionManager.getConnectedServer()) == null) break block6;
                    PostOffice postOffice = server.getPostOffice();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.wily.introscope.spec.server.beans.bizrecording.IEMBizRecordingServiceCallback");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.fConnector = new CallbackConnector(postOffice, this.fCallback, clazz);
                }
                catch (EndpointNotFoundException endpointNotFoundException) {}
            }
        }
        return this.fConnector;
    }

    private boolean matches_90Beta(String ip, String language) {
        if (ip == null || !this.fIpFilter.equals(ip)) {
            return false;
        }
        if (language == null) {
            return false;
        }
        int i = 0;
        while (i < this.fLanguageGlobs.length) {
            if (this.fLanguageGlobs[i].matches(language)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matches_internal(String ip, String language) {
        if (ip != null && this.fIpFilter != null && this.fIpFilter.equals(ip)) {
            return true;
        }
        return language != null && language.length() > 0 && this.fLanguageGlob != null && this.fLanguageGlob.matches(language);
    }

    public boolean matches(String ip, String language) {
        if (this.fUSeTimCompatibleMatching) {
            return this.matches_internal(ip, language);
        }
        return this.matches_90Beta(ip, language);
    }
}

