/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.enterprise;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class AgentWrapperLoader {
    private static final String kAgentWrapperPluginType = "agentwrapper";
    private static final int kCurrentAgentWrapperPluginVersion = 1;
    private static final Class[] kAgentWrapperConstructorParameterTypes;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ExtensionAdministrator fExtensionAdministrator;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.IAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        kAgentWrapperConstructorParameterTypes = classArray;
    }

    public AgentWrapperLoader(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtensionAdministrator extensionAdministrator) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fExtensionAdministrator = extensionAdministrator;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public IAgent createAgentWrapper(IAgent delegate) {
        Class wrapperClass;
        IPlugin[] plugins = this.fExtensionAdministrator.getAgentPluginsByType(kAgentWrapperPluginType);
        if (plugins == null || plugins.length == 0) {
            return delegate;
        }
        IPlugin plugin = plugins[0];
        IModuleFeedbackChannel iModuleFeedbackChannel = this.getModuleFeedback();
        IStringLocalizer iStringLocalizer = this.getStringLocalizer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.IAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wrapperClass = ExtensionUtilities.loadEntryPointClass(iModuleFeedbackChannel, iStringLocalizer, plugin, 1, clazz)) != null) {
            try {
                Constructor constructor = wrapperClass.getConstructor(kAgentWrapperConstructorParameterTypes);
                return (IAgent)constructor.newInstance(delegate);
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", wrapperClass.getName()));
                this.getModuleFeedback().verbose(target);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", wrapperClass.getName()));
            }
            catch (SecurityException securityException) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", wrapperClass.getName()));
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", wrapperClass.getName()));
                this.getModuleFeedback().verbose(t);
            }
        }
        return delegate;
    }
}

