/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalls;

import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.stalls.StallFeature;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StallFeatureStackEntry {
    private static final String STALLED_TRANSACTION = "Stalled Transaction";
    private String fComponentName;
    private boolean fHaveReportedStall = false;
    private boolean fPropagateStallMetric = false;
    private BlameStackFeatureStackEntry fEntry;
    private final long fThresholdInMillis;
    private static final String kMetricNameSuffix = ":Stall Count";
    private final BlameStackFeatureBlameStack fStack;
    private IIntegerFluctuatingCounterDataAccumulator fStallAccumulator;
    private IIntegerFluctuatingCounterDataAccumulator fOriginalComponentStallAccumulator;
    private ArrayList snapshots = new ArrayList(2);
    private final int kOriginalComponentNameIndex = 0;
    private final int kDefaultBackendNameIndex = 1;

    public StallFeatureStackEntry(BlameStackFeatureBlameStack stack, BlameStackFeatureStackEntry entry, long threshold) {
        this.fStack = stack;
        this.fEntry = entry;
        this.fThresholdInMillis = threshold;
    }

    public StallFeatureStackEntry(BlameStackFeatureBlameStack stack, long thresholdInMillis) {
        this(stack, null, thresholdInMillis);
    }

    public boolean checkIfStalled(long now) {
        boolean haveStalled;
        boolean bl = haveStalled = now > this.fEntry.getStartTime() + this.fThresholdInMillis;
        if (haveStalled && !this.fHaveReportedStall) {
            BlameStackSnapshot snapshot = this.fStack.IBlameStack_getSnapshot(this.fComponentName);
            this.forceStallWithoutEvent(snapshot);
            this.fStack.IBlameStack_addExtraParameter("Error Message", STALLED_TRANSACTION);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Trace Type", "ErrorSnapshot");
            params.put("Error Message", STALLED_TRANSACTION);
            this.fStack.makeAndSendSnapshot(null, params);
        }
        return haveStalled;
    }

    public void forceStallWithoutEvent(BlameStackSnapshot snapshot) {
        this.snapshots.add(snapshot);
        String[] defaultBackendData = this.fStack.getDefaultBackendData();
        if (defaultBackendData != null && this.fComponentName.equals(defaultBackendData[1])) {
            this.fStallAccumulator = StallFeature.getDefaultBackendAccumulator(String.valueOf(this.fComponentName) + kMetricNameSuffix);
            this.fStallAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment(snapshot);
            String originalComponentName = defaultBackendData[0];
            this.fOriginalComponentStallAccumulator = StallFeature.getAccumulator(String.valueOf(originalComponentName) + kMetricNameSuffix);
            this.fOriginalComponentStallAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
        } else {
            this.fStallAccumulator = StallFeature.getAccumulator(String.valueOf(this.fComponentName) + kMetricNameSuffix);
            this.fStallAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment(snapshot);
        }
        this.fHaveReportedStall = true;
    }

    public void push(String component) {
        this.fComponentName = component;
        this.fHaveReportedStall = false;
    }

    public void pop() {
        if (this.fHaveReportedStall && this.fStallAccumulator != null) {
            Iterator atSnapshot = this.snapshots.iterator();
            while (atSnapshot.hasNext()) {
                BlameStackSnapshot snapshot = (BlameStackSnapshot)atSnapshot.next();
                this.fStallAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement(snapshot);
                if (this.fOriginalComponentStallAccumulator == null) continue;
                this.fOriginalComponentStallAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
        }
        this.fHaveReportedStall = false;
    }

    public String toString() {
        return "Entry for: " + this.fComponentName;
    }

    public void init(BlameStackFeatureStackEntry entry) {
        this.fEntry = entry;
        this.fHaveReportedStall = false;
        this.fPropagateStallMetric = false;
        this.fStallAccumulator = null;
        this.fOriginalComponentStallAccumulator = null;
        this.snapshots.clear();
    }

    public void setPropagateStallMetric(boolean b) {
        this.fPropagateStallMetric = b;
    }

    public boolean shouldPropagateStallMetric() {
        return this.fPropagateStallMetric;
    }

    public void setBackend(String component) {
        this.fComponentName = component;
    }

    public String getComponent() {
        return this.fComponentName;
    }
}

