/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent.frontend;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationMethodTracer;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import java.util.concurrent.atomic.AtomicLong;

public class FrontendCandidate
implements IIntelligentInstrumentationMethodTracer {
    volatile int fProbeInfoIndex = -1;
    FrontEndCandidateState fState;
    int fStackEntryCount = 0;
    volatile boolean fCompletedTransaction = false;
    volatile boolean fHasTouchedBackend = false;
    AtomicLong fTimestamp = new AtomicLong(0L);
    IAgent fAgent;
    HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack fDeepStack;
    private static IIntelligentInstrumentationTracerHelper fIntelligentInstrumentationService;

    public FrontendCandidate(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IAgent agent) {
        this.fDeepStack = deepStack;
        this.fAgent = agent;
    }

    public int getProbeInfoIndex() {
        return this.fProbeInfoIndex;
    }

    public void initialize(int probeHashCode) {
        this.fProbeInfoIndex = probeHashCode;
        this.fState = FrontEndCandidateState.MONITORED;
        this.fCompletedTransaction = false;
        this.fHasTouchedBackend = false;
        this.fTimestamp.set(System.currentTimeMillis());
    }

    public void reset() {
        this.fTimestamp.set(0L);
        this.fProbeInfoIndex = -1;
        this.fStackEntryCount = 0;
    }

    public FrontEndCandidateState getState() {
        return this.fState;
    }

    public void setState(FrontEndCandidateState state) {
        this.fState = state;
    }

    public int getStackEntryCount() {
        return this.fStackEntryCount;
    }

    public void push() {
        if (this.fStackEntryCount < Integer.MAX_VALUE) {
            ++this.fStackEntryCount;
        }
    }

    public void pop() {
        --this.fStackEntryCount;
        if (this.fStackEntryCount == 0) {
            this.markCompletedTransaction();
        }
    }

    public boolean hasCompletedTransaction() {
        return this.fCompletedTransaction;
    }

    private void markCompletedTransaction() {
        this.fCompletedTransaction = true;
        if (this.fHasTouchedBackend) {
            this.fDeepStack.reportFrontEndCandidateData();
        }
        this.reset();
    }

    public void setHasTouchedBackend() {
        this.fHasTouchedBackend = true;
    }

    public long getTimestamp() {
        return this.fTimestamp.get();
    }

    @Override
    public void IMethodTracer_startTrace() {
        this.push();
        if (Logger.isTraceEnabled()) {
            this.getHelper();
            String[] probeInfo = fIntelligentInstrumentationService.getIntelligentInstrumentationInfoForSequentialHashCode(this.fProbeInfoIndex);
            Logger.logTraceMessage("Entry Point Candidate startTrace:" + this.fProbeInfoIndex + " " + probeInfo[0] + ":" + probeInfo[1] + probeInfo[2]);
        }
    }

    @Override
    public void IMethodTracer_setInvocationObject(Object o) {
    }

    @Override
    public void IMethodTracer_finishTrace() {
        if (this.fProbeInfoIndex != -1) {
            if (Logger.isTraceEnabled()) {
                this.getHelper();
                String[] probeInfo = fIntelligentInstrumentationService.getIntelligentInstrumentationInfoForSequentialHashCode(this.fProbeInfoIndex);
                Logger.logTraceMessage("Entry Point Candidate finishTrace:" + this.fProbeInfoIndex + " " + probeInfo[0] + ":" + probeInfo[1] + probeInfo[2]);
            }
            this.pop();
        }
    }

    private IIntelligentInstrumentationTracerHelper getHelper() {
        if (fIntelligentInstrumentationService == null && this.fAgent != null) {
            try {
                fIntelligentInstrumentationService = this.fAgent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return fIntelligentInstrumentationService;
    }

    @Override
    public void IMethodTracer_startTrace(IMethodTracer data) {
    }

    @Override
    public void IMethodTracer_finishTrace(IMethodTracer data) {
    }

    @Override
    public void IIntelligentInstrumentationMethodTracer_setThrownException(Object exception) {
    }

    @Override
    public void IIntelligentInstrumentationMethodTracer_setThrownException(Object exception, IMethodTracer methodTracer) {
    }

    @Override
    public Object IIntelligentInstrumentationMethodTracer_getExceptionElement() {
        return null;
    }

    @Override
    public boolean IMethodTracer_shouldStub() {
        return false;
    }

    @Override
    public void IMethodTracer_setShouldStub(boolean flag) {
    }

    @Override
    public void IMethodTracer_setReentrancyOverwrite(boolean flag) {
    }

    public static enum FrontEndCandidateState {
        IDENTIFIED("IDENTIFIED"),
        INSTRUMENTED("INSTRUMENTED"),
        MONITORED("MONITORED"),
        REJECTED("REJECTED"),
        PSEUDOFRONTEND("PSEUDOFRONTEND");

        private final String fType;

        private FrontEndCandidateState(String type) {
            this.fType = type;
        }

        public String toString() {
            return this.fType;
        }
    }
}

