/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.wilyassert.Assertion;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelfCleaningSet {
    private static final int kDefaultPurgeInterval = 7500;
    private static final String kSelfCleaningSetName = "SelfCleaningSet";
    private static final int kDefaultAgeLimit = 4;
    private final IntervalHeartbeat fHeartbeat;
    private final Collection fDeadList;
    private IRegisteredBehavior fSetCleaner;
    private final int fAgeLimit;
    private final Map fAgingMap;

    public SelfCleaningSet(IntervalHeartbeat heartbeat, Collection deadList) {
        this(heartbeat, deadList, 7500, 4);
    }

    public SelfCleaningSet(IntervalHeartbeat heartbeat, Collection deadList, int purgeInterval, int ageLimit) {
        Assertion.wilyAssert(heartbeat != null);
        Assertion.wilyAssert(deadList != null);
        Assertion.wilyAssert(purgeInterval > 0);
        Assertion.wilyAssert(ageLimit > 0);
        this.fHeartbeat = heartbeat;
        this.fDeadList = deadList;
        this.fAgeLimit = ageLimit;
        this.fAgingMap = new HashMap();
        this.connectBehavior(purgeInterval);
    }

    public synchronized void add(Object o) {
        Assertion.wilyAssert(o != null);
        if (!this.fAgingMap.containsKey(o)) {
            this.fAgingMap.put(o, new Integer(0));
        }
    }

    public synchronized Object remove(Object o) {
        return this.fAgingMap.remove(o);
    }

    public synchronized boolean contains(Object o) {
        return this.fAgingMap.containsKey(o);
    }

    public synchronized void clear() {
        this.fAgingMap.clear();
    }

    public synchronized void tearDown() {
        this.fHeartbeat.removeBehavior(this.fSetCleaner);
        this.fAgingMap.clear();
    }

    public synchronized void setPurgeInterval(int newPurgeInterval) {
        this.fHeartbeat.removeBehavior(this.fSetCleaner);
        this.connectBehavior(newPurgeInterval);
    }

    private void connectBehavior(long period) {
        this.fSetCleaner = this.fHeartbeat.addBehavior((ITimestampedRunnable)new SetCleaner(), kSelfCleaningSetName, true, period, false);
    }

    synchronized void purgeSet() {
        Assertion.wilyAssert(this.fAgingMap != null);
        if (this.fAgingMap.size() <= 0) {
            return;
        }
        Set set = this.fAgingMap.keySet();
        if (set != null) {
            LinkedList ageList = new LinkedList();
            Iterator i = set.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (this.isRipeForPurging(o)) {
                    i.remove();
                    this.fDeadList.add(o);
                    continue;
                }
                ageList.add(o);
            }
            this.ageElements(ageList);
        }
    }

    private void ageElements(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.incrementElementAge(i.next());
        }
    }

    private boolean isRipeForPurging(Object key) {
        Integer i = (Integer)this.fAgingMap.get(key);
        return i >= this.fAgeLimit;
    }

    private void incrementElementAge(Object key) {
        Integer i = (Integer)this.fAgingMap.remove(key);
        this.fAgingMap.put(key, new Integer(i + 1));
    }

    private class SetCleaner
    implements ITimestampedRunnable {
        private SetCleaner() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            SelfCleaningSet.this.purgeSet();
        }
    }
}

