/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend.log4j;

import com.wily.org.apache.log4j.BasicConfigurator;
import com.wily.org.apache.log4j.ConsoleAppender;
import com.wily.org.apache.log4j.Layout;
import com.wily.org.apache.log4j.Level;
import com.wily.org.apache.log4j.LogManager;
import com.wily.org.apache.log4j.Logger;
import com.wily.org.apache.log4j.PatternLayout;
import com.wily.org.apache.log4j.PropertyConfigurator;
import com.wily.util.LogFileUtilities;
import com.wily.util.feedback.Log4JSeverityLevel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Log4JBackend
implements IFeedbackBackend {
    private static final IFeedbackBackend sSingleton = new Log4JBackend();
    private static final String kLog4JPropertyPrefix = "log4j";

    public static IFeedbackBackend getLog4JBackend() {
        return sSingleton;
    }

    private Log4JBackend() {
    }

    public Object getLoggerByName(String name) {
        Logger l = LogManager.getLogger(name);
        return l;
    }

    public void setGlobalDefaults(String defaultOutputTarget) {
        String log4JTarget = Log4JBackend.mapLog4JTarget(defaultOutputTarget);
        PatternLayout layout = new PatternLayout("%d{M/dd/yy hh:mm:ss a z} [%-3p] [%c] %m%n");
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout, log4JTarget);
        BasicConfigurator.configure(consoleAppender);
        Logger.getRootLogger().setLevel(Log4JSeverityLevel.INFO);
    }

    private static String mapLog4JTarget(String defaultOutputTarget) {
        if (defaultOutputTarget.equals("DefaultSystemOut")) {
            return "System.out";
        }
        if (defaultOutputTarget.equals("DefaultSystemError")) {
            return "System.err";
        }
        return "System.err";
    }

    public void setGlobalConfiguration(Properties props) {
        this.ensureLogDirectory(props);
        PropertyConfigurator.configure(props);
    }

    private void ensureLogDirectory(Properties props) {
        List appendersBasedOnFile = LogFileUtilities.getAppendersBasedOnFile(props);
        Iterator i = appendersBasedOnFile.iterator();
        while (i.hasNext()) {
            String appenderPropKey = (String)i.next();
            String logFilePath = props.getProperty(appenderPropKey);
            LogFileUtilities.ensureLogFilePath(logFilePath);
        }
    }

    public void configureFromProperties(Properties properties) {
        this.ensureLogDirectory(properties);
        PropertyConfigurator.configure(properties);
    }

    public boolean containsLoggingConfiguration(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (attribute.indexOf(kLog4JPropertyPrefix) < 0) continue;
            return true;
        }
        return false;
    }

    private Logger getLoggerFromObjectCookie(Object cookie) {
        return (Logger)cookie;
    }

    public void log(Object logger, SeverityLevel level, Object message, Throwable t) {
        this.getLoggerFromObjectCookie(logger).log(Log4JSeverityLevel.getLog4JSeverityLevel(level), message, t);
    }

    public SeverityLevel getEffectiveLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getEffectiveLevel();
        return Log4JSeverityLevel.getSeverityLevelFromLog4J(level);
    }

    public SeverityLevel getLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getLevel();
        return Log4JSeverityLevel.getSeverityLevelFromLog4J(level);
    }

    public void setLevel(Object logger, SeverityLevel level) {
        this.getLoggerFromObjectCookie(logger).setLevel(Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public boolean isEnabledFor(Object logger, SeverityLevel level) {
        return this.getLoggerFromObjectCookie(logger).isEnabledFor(Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public void setRootLevel(SeverityLevel level) {
        LogManager.getRootLogger().setLevel(Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public boolean isRootEnabledFor(SeverityLevel level) {
        return LogManager.getRootLogger().isEnabledFor(Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public String getName(Object logger) {
        return this.getLoggerFromObjectCookie(logger).getName();
    }
}

