/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.entrypoint.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.probe.net.ManagedSocketMapHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.io.SocketBackendTracer;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketFormatterCache;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.QueueWrapper;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketInputStream;
import java.util.Iterator;

public final class AgentSocketInputStream {
    private static final IWeakIdentityMap kMap;
    private static final int kDefaultMaxSize = 256;
    private static final int kMaxQueueSize;
    private static final String kAnnotateTitle = "Socket Read";
    private WeakReference<Socket> fWilySocket;
    private volatile SocketFormatMetricsCache fCache;

    static {
        try {
            ManagedSocketMapHelper.initializeIfNeccessary();
        }
        catch (Throwable t) {
            AgentShim.handleError("Exception in initializing ManagedSocketMapHelper", t);
        }
        IWeakIdentityMap LRUHighConcurrencyMap = null;
        int valueForMaxQueue = 256;
        try {
            IAgent agent = ManagedSocketMapHelper.getAgent();
            if (agent != null) {
                IConcurrentMapFactory factory = agent.IAgent_getConcurrentMapFactory();
                if (factory != null) {
                    LRUHighConcurrencyMap = factory.getConcurrentCappedWeakIdentityMap("managedSocketInput");
                }
                valueForMaxQueue = agent.IAgent_getIndexedProperties().getIntProperty("concurrentMapPolicy.managedSocketInput.maxqueuesize", 256);
            }
        }
        catch (Throwable t) {
            AgentShim.handleError("Exception in initializing ManagedSocketInputStreamHighPerformanceNew", t);
        }
        if (LRUHighConcurrencyMap != null) {
            kMap = LRUHighConcurrencyMap;
        } else {
            AgentShim.handleDebug("Exception in initializing ManagedSocketInputStreamHighPerformanceNew. No map for handling matching of stream with sockets.", new Exception());
            kMap = null;
        }
        kMaxQueueSize = valueForMaxQueue;
    }

    public static void postFlight(Socket socket, SocketFormatMetricsCache cache) {
        QueueWrapper list;
        if (kMap != null && (list = (QueueWrapper)kMap.getWeak(socket)) != null) {
            Iterator<?> i = list.iterator();
            while (i.hasNext()) {
                Socket s;
                WeakReference wr = (WeakReference)i.next();
                AgentSocketInputStream element = (AgentSocketInputStream)wr.get();
                if (element == null || (s = element.getWilySocket()) == null || s != socket || element.fCache != null) continue;
                element.fCache = cache;
                list.removeCurrentInIterator(i);
            }
        }
    }

    protected void setCache(Socket socket) {
        this.fWilySocket = new WeakReference<Socket>(socket);
        ConcurrentWeakThreadLocalHashMap<Socket, SocketFormatMetricsCache> map = SocketFormatterCache.kSocketMetricCache;
        this.fCache = map.getWeak(socket);
        if (this.fCache == null && kMap != null) {
            QueueWrapper listInMap = (QueueWrapper)kMap.getWeak(socket);
            if (listInMap == null) {
                listInMap = new QueueWrapper(kMaxQueueSize);
            }
            listInMap.offer(new WeakReference<AgentSocketInputStream>(this));
            if (kMap.containsWeakKey(socket)) {
                QueueWrapper existingList = (QueueWrapper)kMap.getWeak(socket);
                existingList.offer(new WeakReference<AgentSocketInputStream>(this));
            } else {
                kMap.putWeak(socket, listInMap);
            }
        }
    }

    AgentSocketInputStream() {
    }

    public final Socket getWilySocket() {
        return (Socket)this.fWilySocket.get();
    }

    public boolean addToConcurrentReaders(String methodName) {
        boolean addedToConcurrentReaders = false;
        try {
            this.fCache.addToConcurrentReaders();
            addedToConcurrentReaders = true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in preparing " + methodName + " from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return addedToConcurrentReaders;
    }

    public SocketFormatMetricsCache getCache() {
        return this.fCache;
    }

    public void addToInputBandwidth(int numberOfBytesRead) {
        try {
            this.fCache.addToInputBandwidth(numberOfBytesRead);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public void removeFromConcurrentReaders(boolean addedToConcurrentReaders, String MethodName2) {
        try {
            if (addedToConcurrentReaders) {
                this.fCache.removeFromConcurrentReaders();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in " + MethodName2 + " from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public final void removeFromAppMap(int addedComponentInfo, String methodName) {
        try {
            String component;
            if (this.fCache.isClientConnection() && (component = this.fCache.getFormattedMetrics(10)) != null) {
                ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedComponentInfo, component);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in completing " + methodName + " from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public final int addToAppMap() {
        int result = 0;
        String component = this.fCache.getFormattedMetrics(10);
        if (component != null) {
            result = ManagedSocketMapHelper.addToAppMapIfEnabled(component);
        }
        return result;
    }

    public final void annotateBlameStack(SocketInputStream socketIStream) {
        IBlameStackAnnotator defaultBackendBlameStackAnnotator;
        IStackElement currentData = VirtualStack.peekIfNew(socketIStream);
        if (currentData == null) {
            return;
        }
        ITransactionElement currentCursor = currentData.getCursor();
        if (currentCursor != null && (defaultBackendBlameStackAnnotator = BlameStackAnnotationHelper.getBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator)) != null) {
            String formattedMetricName = this.fCache.getFormattedMetrics(9);
            defaultBackendBlameStackAnnotator.annotateBlameStack((Object)formattedMetricName, currentCursor, currentData, true);
        }
    }

    public final void annotateBlameStack() {
        String formattedMetricName = this.fCache.getFormattedMetrics(9);
        SocketBackendTracer.annotateBlameStack(formattedMetricName, kAnnotateTitle, this.fCache);
    }

    public final boolean suggestStackTraceRecording() {
        return AutomaticBoundaryDetectionAdmin.getInstance().getStrackTraceRecorder().record();
    }
}

