/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.rules;

import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleChain;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;

public abstract class AbstractRule
implements Rule {
    public void execute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status, RuleChain ruleChain) {
        boolean result = this.doExecute(currentElementIndex, trace, status);
        if (result) {
            status.markAsCandidate();
            if (Logger.isDebugEnabled()) {
                Logger.logDebugMessage((String)("Rule: " + this.toString() + " has marked element:" + trace[currentElementIndex] + " as candidate."));
            }
        }
        ruleChain.doExecuteNextRule(currentElementIndex, trace, status);
    }

    public abstract boolean doExecute(int var1, IndexAwareTraceElement[] var2, ExecutionStatus var3);

    public String toString() {
        return Utils.formatStringRep(this.getClass().getSimpleName());
    }
}

