/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.WrappedStackTraceElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class StackTraceRepository {
    private static Queue<StackTraceElement[]> tracesQueue = new ConcurrentLinkedQueue<StackTraceElement[]>();
    private static final AgentElementsFilter agentElementsFilter = new AgentElementsFilter();

    public static void add(StackTraceElement[] trace) {
        tracesQueue.add(trace);
    }

    public static StackTraceElement[] poll() {
        return tracesQueue.poll();
    }

    public static IndexAwareTraceElement[] pollWrappedTrace() {
        return StackTraceRepository.wrapTrace(tracesQueue.poll());
    }

    public static IndexAwareTraceElement[] wrapTrace(StackTraceElement[] origTrace) {
        StackTraceElement[] filteredTrace = agentElementsFilter.filter(origTrace);
        IndexAwareTraceElement[] wrappedTrace = null;
        if (filteredTrace != null && filteredTrace.length > 0) {
            int length = filteredTrace.length;
            wrappedTrace = new IndexAwareTraceElement[length];
            StackTraceElement element = null;
            int index = 0;
            while (index < length) {
                element = filteredTrace[index];
                wrappedTrace[index] = new WrappedStackTraceElement(element, index, length);
                ++index;
            }
        }
        return wrappedTrace;
    }

    public static int size() {
        return tracesQueue.size();
    }

    public static boolean isEmpty() {
        return tracesQueue.isEmpty();
    }

    public static boolean isFull() {
        return StackTraceRepository.size() >= EntryPointDetectionConfiguration.getStackTracesLimitPerInterval();
    }

    public static void clear() {
        tracesQueue.clear();
    }

    public static class AgentElementsFilter {
        private final Set<Pattern> packagePrefixesForAgentElements = new HashSet<Pattern>();
        private static final String GET_STACK_TRACE_ELEMENT_CLASS_NAME = "java.lang.Thread";
        private static final String GET_STACK_TRACE_ELEMENT_METHOD_NAME = "getStackTrace";

        public AgentElementsFilter(Set<String> packageExprns) {
            this(packageExprns, true);
        }

        public AgentElementsFilter(Set<String> packageExprns, boolean isRegexBased) {
            for (String packageExpr : packageExprns) {
                if (!isRegexBased) {
                    packageExpr = Utils.convertToPackageRegex(packageExpr);
                }
                this.packagePrefixesForAgentElements.add(Pattern.compile(packageExpr, 2));
            }
        }

        public AgentElementsFilter(String commadSepratedPackagesList) {
            String[] stringArray = commadSepratedPackagesList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                pkg = Utils.convertToPackageRegex(pkg);
                this.packagePrefixesForAgentElements.add(Pattern.compile(pkg, 2));
                ++n2;
            }
        }

        public AgentElementsFilter() {
            this("com.ca,com.wily");
        }

        public StackTraceElement[] filter(StackTraceElement[] traceElements) {
            if (traceElements != null && traceElements.length > 0) {
                StackTraceElement[] includedElements = null;
                StackTraceElement element = null;
                int size = traceElements.length;
                int index = 0;
                element = traceElements[0];
                if (element.getClassName().equals(GET_STACK_TRACE_ELEMENT_CLASS_NAME) && element.getMethodName().equals(GET_STACK_TRACE_ELEMENT_METHOD_NAME)) {
                    index = 1;
                }
                int i = index;
                while (i < size) {
                    element = traceElements[i];
                    if (!Utils.doesElementPackageMatch(element, this.packagePrefixesForAgentElements)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                includedElements = Arrays.copyOfRange(traceElements, index, size);
                return includedElements;
            }
            return traceElements;
        }
    }
}

