/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.extension.instrument.intelligent;

import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.DGIntelligentInstrumentationStreamTracer;
import com.wily.diagnos.cmp.tracer.MethodTracerAggregatorPluginFactory;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.introscope.probebuilder.instrumentation.IInstrumentationDeciderFactoryDelegate;
import com.wily.introscope.probebuilder.instrumentation.InstrumentationDeciderFactory;
import com.wily.introscope.probebuilder.instrumentation.level.IInstrumentationChangeListener;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationChangeListener;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationDeciderDelegate;
import java.lang.instrument.Instrumentation;

public class InstrumentIntelligently {
    public InstrumentIntelligently(IAgent agent, IDynamicInstrumentationTransformer transformer, ICompilerLogger logger, IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        if (!this.isIntelligentInstrumentationEnabled(agent)) {
            return;
        }
        this.configure(agent);
        MethodTracerAggregatorPluginFactory.addAggregator((String)"intelligentAggregator", (DGAggregateMethodTracer)new DGIntelligentInstrumentationStreamTracer(logger.getCompilerLog()));
    }

    private void configure(IAgent agent) {
        IntelligentInstrumentationConfig.INSTANCE.init(agent);
        InstrumentationDeciderFactory.setDelegate((IInstrumentationDeciderFactoryDelegate)new IntelligentInstrumentationDeciderDelegate());
        ClassSettingsApplier.setInstrumentationChangeListener((IInstrumentationChangeListener)new IntelligentInstrumentationChangeListener());
    }

    private boolean isIntelligentInstrumentationEnabled(IAgent agent) {
        boolean isOldMode = agent.IAgent_getComponentTracer().isAgentOldMode();
        boolean iiEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled");
        if (isOldMode && iiEnabled) {
            agent.IAgent_getIndexedProperties().setBooleanProperty("introscope.agent.deep.instrumentation.enabled", false);
            agent.IAgent_getModuleFeedback().warn("Intelligent instrumentation is turned off due to use of old agent configuration.");
            iiEnabled = false;
        }
        return iiEnabled;
    }
}

