/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.analysis;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.intelligent.VisibilityGapManager;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.probebuilder.intelligent.analysis.AutoInstrumentationClassReloader;
import com.wily.introscope.probebuilder.intelligent.analysis.ExclusiveExecutionLock;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationProperties;
import com.wily.introscope.probebuilder.intelligent.util.ClassMethodInfo;
import com.wily.introscope.probebuilder.intelligent.util.ClassUtil;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AutoInstrumentationWorker
implements Runnable {
    IAgent fAgent;
    ScheduledExecutorService executor;
    public static AtomicInteger fBatchCounter;
    Module fModule;
    WorkerType fType;
    private ArrayList fRedefineList;

    public AutoInstrumentationWorker(IAgent fAgent, Module mod, ScheduledExecutorService executor, WorkerType type) {
        this.fAgent = fAgent;
        this.executor = executor;
        fBatchCounter = new AtomicInteger(0);
        this.fModule = mod;
        this.fType = type;
    }

    @Override
    public void run() {
        if (this.fType == WorkerType.VISIBILITYGAP) {
            this.executeVisibilityGapAutoInstrumentation();
        } else if (this.fType == WorkerType.AUTOFRONTEND) {
            this.redefineClassWithMethodsMarkedAsFrontend();
        }
    }

    private void executeVisibilityGapAutoInstrumentation() {
        if (ExclusiveExecutionLock.getExclusive()) {
            HashMap classesToFind = new HashMap();
            HashMap calledClassMethodMap = new HashMap();
            this.processMethodsInstrumentedByIntelligentTracer(classesToFind);
            this.processMethodsInstrumentedByNormaltTracer(classesToFind);
            HashMap classMethodsWithGap = ClassUtil.getJavaClassFromVM(classesToFind, false, this.fAgent);
            this.processClassMethodsWithVisibilityGap(classMethodsWithGap, calledClassMethodMap);
            HashMap redefineClassesMap = this.filterCalledClassMethods(calledClassMethodMap);
            if (redefineClassesMap.size() > 0) {
                ClassUtil.publishAutoInstrumentedMethods(redefineClassesMap);
                this.scheduleReloadBatch(redefineClassesMap);
                VisibilityGapManager.clear();
            } else {
                ExclusiveExecutionLock.resetExclusive();
            }
        }
    }

    private void scheduleReloadBatch(HashMap<String, ClassMethodInfo> classMap) {
        int time_counter = 0;
        int batchInterval = IntelligentInstrumentationConfig.INSTANCE.getReloadedClassesBatchInterval();
        int batchSize = IntelligentInstrumentationConfig.INSTANCE.getReloadedClassesBatchSize();
        if (batchInterval < 1) {
            batchInterval = IntelligentInstrumentationProperties.kReloadedClassesBatchIntervalDefault;
        }
        if (batchSize < 1) {
            batchSize = IntelligentInstrumentationProperties.kReloadedClassesBatchSizeDefault;
        }
        int count = 0;
        ArrayList<ClassMethodInfo> classList = new ArrayList<ClassMethodInfo>();
        Iterator<String> it = classMap.keySet().iterator();
        while (it.hasNext()) {
            String classNameKey = it.next();
            classList.add(classMap.get(classNameKey));
            if (++count != batchSize && (it.hasNext() || count <= 0)) continue;
            AutoInstrumentationClassReloader reloadClassesWorker = new AutoInstrumentationClassReloader(this.fAgent, this, classList);
            this.executor.schedule(reloadClassesWorker, (long)(batchInterval * 60 * time_counter), TimeUnit.SECONDS);
            ++time_counter;
            count = 0;
            classList = new ArrayList();
            fBatchCounter.incrementAndGet();
        }
        if (fBatchCounter.get() == 0) {
            ExclusiveExecutionLock.resetExclusive();
        }
    }

    private HashMap filterCalledClassMethods(HashMap calledClassMethodMap) {
        HashMap<String, ClassMethodInfo> notSkippedClassesMap = ClassUtil.filterSkippedClasses(this.fAgent, calledClassMethodMap);
        HashMap classMethodMapWithClazz = ClassUtil.getJavaClassFromVM(notSkippedClassesMap, true, this.fAgent);
        HashMap classMethodMap = ClassUtil.filterUnRedefineableClasses(this.fAgent, classMethodMapWithClazz);
        HashMap redefineClassesMap = ClassUtil.filterInstrumentedMethods(this.fAgent, classMethodMap);
        return redefineClassesMap;
    }

    public String[] getIntelligentInstrumentationInfoForSequentialHashCode(int value) {
        return DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.get(value);
    }

    private void processClassMethodsWithVisibilityGap(HashMap classMethodsWithGap, HashMap calledClassMethodMap) {
        int fClassFileSizeLimit = 0x100000;
        Set keys = classMethodsWithGap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ClassMethodInfo cmvg = (ClassMethodInfo)classMethodsWithGap.get(it.next());
            byte[] classBytes = null;
            try {
                classBytes = ByteClassUtil.getBytesForClass((Class)cmvg.clazz, (int)fClassFileSizeLimit, (IModuleFeedbackChannel)this.fAgent.IAgent_getModuleFeedback());
                ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
                DGClass modeledClass = new DGClass((InputStream)input);
                Iterator it1 = modeledClass.getAllDeclaredMethods();
                while (it1.hasNext()) {
                    DGMethod dgMethod = (DGMethod)it1.next();
                    if (!cmvg.contains(dgMethod)) continue;
                    List calledMethods = dgMethod.getInvocations();
                    for (DGFieldMethodRefConstant dgMethodRef : calledMethods) {
                        try {
                            ClassName iclass = ClassName.getClassName((String)dgMethodRef.getClassName());
                            String className = iclass.getReflectionFriendlyQualifiedNameString();
                            String methodName = dgMethodRef.getName();
                            String descriptor = dgMethodRef.getType();
                            ClassMethodInfo gapFiller = (ClassMethodInfo)calledClassMethodMap.get(className);
                            if (gapFiller == null) {
                                gapFiller = new ClassMethodInfo(className);
                                calledClassMethodMap.put(className, gapFiller);
                            }
                            gapFiller.addMethod(methodName, descriptor);
                            this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, "Called Method :" + className + "::" + methodName + descriptor);
                        }
                        catch (InvalidClassNameException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DGClassLoadingException e) {
                e.printStackTrace();
            }
        }
    }

    private void processMethodsInstrumentedByIntelligentTracer(HashMap classesToFind) {
        Set keys = VisibilityGapManager.methodByTracerCode.keySet();
        for (Integer tracerCode : keys) {
            String[] method = this.getIntelligentInstrumentationInfoForSequentialHashCode(tracerCode);
            this.fAgent.IAgent_getModuleFeedback().trace("DeepTrace Method with gap: " + method[0] + "::" + method[1] + method[2]);
            ClassMethodInfo gapclass = (ClassMethodInfo)classesToFind.get(method[0]);
            if (gapclass == null) {
                gapclass = new ClassMethodInfo(method[0]);
                classesToFind.put(method[0], gapclass);
            }
            gapclass.addMethod(method[1], method[2]);
        }
    }

    private void processMethodsInstrumentedByNormaltTracer(HashMap classesToFind) {
        Set keys = VisibilityGapManager.methodByProbeInfo.keySet();
        for (ProbeInformation probeInfo : keys) {
            ProbeIdentification pId = probeInfo.getProbeIdentification();
            String className = pId.getProbeClassName();
            String methodName = pId.getProbeMethodName();
            String methodDesc = pId.getProbeMethodDescriptor();
            this.fAgent.IAgent_getModuleFeedback().trace("Normal Method with gap: " + className + "::" + methodName + methodDesc);
            ClassMethodInfo gapclass = (ClassMethodInfo)classesToFind.get(className);
            if (gapclass == null) {
                gapclass = new ClassMethodInfo(className);
                classesToFind.put(className, gapclass);
            }
            gapclass.addMethod(methodName, methodDesc);
        }
    }

    public void notifyCompletedRedefinitionTask() {
        if (fBatchCounter.decrementAndGet() == 0) {
            ExclusiveExecutionLock.resetExclusive();
        }
    }

    public void redefineClassWithMethodsMarkedAsFrontend() {
        if (ExclusiveExecutionLock.getExclusive()) {
            HashMap classesToFind = new HashMap();
            ClassUtil.createWrapperClassMethodHelper(this.fRedefineList, classesToFind);
            HashMap mapWithClasses = ClassUtil.getJavaClassFromVM(classesToFind, false, this.fAgent);
            HashMap redefineClassesMap = this.filterCalledClassMethods(mapWithClasses);
            if (redefineClassesMap.size() > 0) {
                ClassUtil.publishAutoInstrumentedMethods(redefineClassesMap);
                this.scheduleReloadBatch(redefineClassesMap);
            } else {
                ExclusiveExecutionLock.resetExclusive();
            }
        }
    }

    public void setClassesToRedefine(ArrayList redefineList) {
        int i = 0;
        while (i < redefineList.size()) {
            String className = ((String[])redefineList.get(i))[0];
            AnalysedClassesMapInitializer.addToDoNotSkipList((String)className.replace('.', '/'));
            ++i;
        }
        this.fRedefineList = redefineList;
    }

    public static enum WorkerType {
        VISIBILITYGAP,
        AUTOFRONTEND;

    }
}

