/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceHelper;
import com.wily.introscope.probebuilder.intelligent.instrumentation.LevelChangeChecker;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LevelChangeExecutor {
    static ScheduledExecutorService executor;
    static Runnable levelCheckerWorker;
    static Runnable filePersistWorker;

    public static void startExecutor(IAgent fAgent) {
        executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        levelCheckerWorker = new LevelChangeChecker(fAgent, executor);
        filePersistWorker = new FilePersistenceHelper(fAgent);
    }

    public static void scheduleExecutor(IAgent fAgent) {
        executor.schedule(levelCheckerWorker, 0L, TimeUnit.SECONDS);
    }

    public static void scheduleFilePersistenceExecutor() {
        executor.scheduleAtFixedRate(filePersistWorker, 0L, 60L, TimeUnit.SECONDS);
    }
}

