/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.util;

import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.introscope.probebuilder.intelligent.util.MethodInfo;
import com.wily.util.classfile.IMethodName;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassMethodInfo {
    public String className;
    public Class clazz;
    public HashMap methodsWithGap = new HashMap();

    public ClassMethodInfo(String className2) {
        this.className = className2;
    }

    public void setMethodsToInstrument(ArrayList<DGMethod> methodstoInstrument) {
        this.methodsWithGap = new HashMap();
        for (DGMethod method : methodstoInstrument) {
            IMethodName methodName = method.getMethodName();
            String name = methodName.getNameString();
            String desc = method.getTypeDescriptor();
            this.addMethod(name, desc);
        }
    }

    public boolean contains(DGMethod dgMethod) {
        IMethodName methodName = dgMethod.getMethodName();
        dgMethod.getModeledClass().getClassName();
        String searchKey = methodName.getNameAndSignatureString();
        MethodInfo mg = (MethodInfo)this.methodsWithGap.get(searchKey);
        return mg != null;
    }

    public boolean contains(String methodDesc) {
        MethodInfo mg = (MethodInfo)this.methodsWithGap.get(methodDesc);
        return mg != null;
    }

    public String getDirectiveType(String methodDesc) {
        MethodInfo mg = (MethodInfo)this.methodsWithGap.get(methodDesc);
        if (mg != null) {
            return mg.directiveType;
        }
        return null;
    }

    public void addMethod(String method, String desc) {
        MethodInfo mg = new MethodInfo(method, desc);
        this.methodsWithGap.put(String.valueOf(method) + desc, mg);
    }

    public void addMethodWithDirectiveType(String method, String desc, String type) {
        MethodInfo mg = new MethodInfo(method, desc, type);
        if (this.methodsWithGap.containsKey(String.valueOf(method) + desc)) {
            MethodInfo meth = (MethodInfo)this.methodsWithGap.get(String.valueOf(method) + desc);
            if (meth.directiveType.equalsIgnoreCase("skip")) {
                return;
            }
        }
        this.methodsWithGap.put(String.valueOf(method) + desc, mg);
    }
}

