/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agentmgr.core.result;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AgentMgrResult
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 9L;
    public static final int kUndefinedStatus = -1;
    public static final int kNormalStatus = 0;
    public static final int kNullStatus = 1;
    public static final int kGenericErrorStatus = 100;
    public static final int kConnectionExceptionErrorStatus = 101;
    public static final int kPropertyChangeFailed = 102;
    public static final int kPropertyNotFound = 107;
    public static final int kInvalidPropertyName = 108;
    public static final int kAgentNotConnected = 109;
    public static final int kServiceAvailable = 111;
    public static final int kServiceDisabled = 112;
    public static final int kInvalidArgument = 114;
    public static final int kAgentBusy = 115;
    public static final int kNotAuthorized = 116;
    public static final int kPropertyChangeSuccess = 90;
    private int fStatus;
    private String fAgentName;
    private String fCauseVerbose;
    private int fResultType;

    public AgentMgrResult(String agentName, int status, int resultType) {
        this.fAgentName = agentName;
        this.fStatus = status;
        this.fResultType = resultType;
    }

    public AgentMgrResult() {
    }

    public AgentMgrResult(AgentMgrResult agentMgrResult) {
        this.fAgentName = agentMgrResult.fAgentName;
        this.fStatus = agentMgrResult.fStatus;
        this.fResultType = agentMgrResult.fResultType;
    }

    public String getAgentName() {
        return this.fAgentName;
    }

    public void setAgentName(String agentName) {
        this.fAgentName = agentName;
    }

    public int getStatus() {
        return this.fStatus;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fStatus = in.readInt();
        this.fAgentName = (String)in.readObject();
        this.fCauseVerbose = (String)in.readObject();
        this.fResultType = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fStatus);
        out.writeObject(this.fAgentName);
        out.writeObject(this.fCauseVerbose);
        out.writeInt(this.fResultType);
    }

    public String getErrorStatus() {
        return "Agent Name: " + this.fAgentName + "; Status: " + this.fStatus + ", is Error " + this.isError() + "; " + this.fCauseVerbose;
    }

    public boolean isError() {
        return this.fStatus < 0 || this.fStatus >= 100;
    }

    public Object clone() {
        return new AgentMgrResult(this);
    }

    public AgentMgrResult setVerboseCause(String causeVerbose) {
        this.fCauseVerbose = causeVerbose;
        return this;
    }

    public void setResultType(int resultType) {
        this.fResultType = resultType;
    }

    public int getResultType() {
        return this.fResultType;
    }

    public void setStatus(int status) {
        this.fStatus = status;
    }

    public String getCauseVerbose() {
        return this.fCauseVerbose;
    }
}

