/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.install.KIntroscopeConfigConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.text.IStringLocalizer;

public final class SQLAgentConfiguration {
    private static SQLAgentConfiguration sInstance;
    private static final Module fModule;
    private final int fNormalizedMaxSQLLength;
    private final boolean fParticipateInBlame;
    private final String fNormalizerName;
    private final int fNormalizerErrorCount;
    private final boolean fRunPredefinedScheme;
    private SQLAgentBooleanConfigurationProperty fbTurnOffMetrics;
    private SQLAgentBooleanConfigurationProperty fbOnlyARTMetric;
    private SQLAgentBooleanConfigurationProperty fbIncludeRawSQL;
    private SQLAgentBooleanConfigurationProperty fbTurnOffTraces;

    static {
        fModule = new Module("SQLAgent Configuration");
    }

    public static synchronized SQLAgentConfiguration getInstance(IAgent agent) {
        if (sInstance == null) {
            sInstance = new SQLAgentConfiguration(agent);
        }
        return sInstance;
    }

    private SQLAgentConfiguration(IAgent agent) {
        this.fNormalizedMaxSQLLength = agent.IAgent_getIndexedProperties().safeGetIntProperty("introscope.agent.sqlagent.sql.maxlength", 990, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        agent.IAgent_getModuleFeedback().debug(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("SQLAgent_Configured_Max_SQL_Length", String.valueOf(this.fNormalizedMaxSQLLength)));
        this.fParticipateInBlame = agent.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.agent.sqlagent.useblame", true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        agent.IAgent_getModuleFeedback().debug(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("SQLAgent_Configured_Blame_Participation", String.valueOf(this.fParticipateInBlame)));
        this.fNormalizerErrorCount = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty("introscope.agent.sqlagent.normalizer.extension.errorCount", 5, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        agent.IAgent_getModuleFeedback().debug(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("SQLAgent_Configured_Normalizer_Extension_ErrorCount_Message", String.valueOf(this.fNormalizerErrorCount)));
        this.fRunPredefinedScheme = agent.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.agent.sqlagent.normalizer.extension.runPredefinedScheme", false, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        agent.IAgent_getModuleFeedback().debug(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("SQLAgent_Configured_Normalizer_Extension_RunPredefinedScheme_Message", String.valueOf(this.fRunPredefinedScheme)));
        String name = agent.IAgent_getIndexedProperties().getTrimmedProperty("introscope.agent.sqlagent.normalizer.extension", "");
        if (name.length() > 0) {
            this.fNormalizerName = name;
            agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("SQLAgent_Configured_Normalizer_Extension_Message", this.fNormalizerName));
        } else {
            this.fNormalizerName = null;
            agent.IAgent_getModuleFeedback().info("Statement Normalizer: will use preconfigured normalization scheme");
        }
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        this.fbTurnOffMetrics = new SQLAgentBooleanConfigurationProperty("introscope.agent.sqlagent.sql.turnoffmetrics", KIntroscopeConfigConstants.kSQLAgentDefaultTurnOffMetrics, "SQLAgent_Turn_Off_Metrics", agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        cm.add(this.fbTurnOffMetrics);
        this.fbOnlyARTMetric = new SQLAgentBooleanConfigurationProperty("introscope.agent.sqlagent.sql.artonly", KIntroscopeConfigConstants.kSQLAgentDefaultReportOnlyARTMetric, "SQLAgent_Report_Only_ART_Metric", agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        cm.add(this.fbOnlyARTMetric);
        this.fbIncludeRawSQL = new SQLAgentBooleanConfigurationProperty("introscope.agent.sqlagent.sql.rawsql", KIntroscopeConfigConstants.kSQLAgentDefaultRawSqlInTrace, "SQLAgent_Raw_SQL_In_Trace", agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        cm.add(this.fbIncludeRawSQL);
        this.fbTurnOffTraces = new SQLAgentBooleanConfigurationProperty("introscope.agent.sqlagent.sql.turnofftrace", KIntroscopeConfigConstants.kSQLAgentDefaultTurnOffTrace, "SQLAgent_Turn_Off_Trace", agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        cm.add(this.fbTurnOffTraces);
    }

    public int getNormalizedMaxSQLLength() {
        return this.fNormalizedMaxSQLLength;
    }

    public boolean shouldParticipateInBlame() {
        return this.fParticipateInBlame;
    }

    public String getNormalizerExtensionName() {
        return this.fNormalizerName;
    }

    public int getNormalizerExtensionErrorCount() {
        return this.fNormalizerErrorCount;
    }

    public boolean getNormalizerExtensionRunPredefinedScheme() {
        return this.fRunPredefinedScheme;
    }

    public boolean isMetricsTurnedOff() {
        return this.fbTurnOffMetrics.isEnabled();
    }

    public boolean shouldReportOnlyARTMetric() {
        return this.fbOnlyARTMetric.isEnabled();
    }

    public boolean shouldIncludeRawSQL() {
        return this.fbIncludeRawSQL.isEnabled();
    }

    public boolean isTracesTurnedOff() {
        return this.fbTurnOffTraces.isEnabled();
    }

    private class SQLAgentBooleanConfigurationProperty
    extends BooleanConfigurationProperty {
        boolean value;

        private SQLAgentBooleanConfigurationProperty(String name, Boolean defaultValue, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, descriptionKey, feedback, module, localizer);
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }
}

