/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLJRTStatementToSQLMappingTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class SQLJRTResultSetToSQLMappingTracer
extends ASingleInstanceTracerFactory {
    private static final Map sRTResultSetMap;
    private static final String kRTResultSetClassName = "COM.ibm.db2os390.sqlj.runtime.DB2SQLJRTResultSet";
    private static final String kRTStatementClassName = "COM.ibm.db2os390.sqlj.runtime.DB2SQLJRTStatement";
    private static final String kRTResultSetFieldName = "sqljRTResultSet";

    static {
        Map resultSetMap = null;
        try {
            resultSetMap = Collections.synchronizedMap(new WeakHashMap());
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception initializing SQLJRTResultSetToSQLMappingTracer", (Throwable)t);
            }
            catch (Throwable throwable) {}
        }
        sRTResultSetMap = resultSetMap;
    }

    public SQLJRTResultSetToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long generatedTime = data.getWallClockFinishTime();
        if (this.getProbeIdentification().getProbeMethodName().equalsIgnoreCase("executeRTQuery")) {
            Object resultSet = data.getInvocationReturnValueAsObject();
            if (resultSet == null) {
                return;
            }
            if (!resultSet.getClass().getName().equalsIgnoreCase(kRTResultSetClassName)) {
                Assertion.wilyAssert("expected a DB2SQLJRTResultSet");
                return;
            }
            Object statement = data.getInvocationObject();
            if (statement == null || !statement.getClass().getName().equalsIgnoreCase(kRTStatementClassName)) {
                Assertion.wilyAssert("expected a DB2SQLJRTStatement");
                return;
            }
            String sql = this.getCreationSQL(statement, data);
            String type = this.getCreationSQLType(statement);
            if (sql != null && type != null) {
                sRTResultSetMap.put(resultSet, new ResultSetCreationRecord(sql, type, generatedTime, data.getInvocationObject()));
            }
        } else {
            Object resultSet = data.getInvocationParameterAsObject(1);
            if (resultSet.getClass().getName().equalsIgnoreCase(kRTResultSetClassName)) {
                try {
                    if (resultSet.getClass().getField(kRTResultSetFieldName) != null && !sRTResultSetMap.containsKey(resultSet)) {
                        Object statement = data.getInvocationObject();
                        if (statement == null || !statement.getClass().getName().equalsIgnoreCase(kRTStatementClassName)) {
                            Assertion.wilyAssert("expected a DB2SQLJRTStatement");
                            return;
                        }
                        String sql = this.getCreationSQL(statement, data);
                        String type = this.getCreationSQLType(statement);
                        if (sql != null && type != null) {
                            sRTResultSetMap.put(resultSet, new ResultSetCreationRecord(sql, type, generatedTime, data.getInvocationObject()));
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
    }

    protected String getCreationSQLType(Object statement) {
        return SQLJRTStatementToSQLMappingTracer.getSQLType(statement);
    }

    protected String getCreationSQL(Object statement, InvocationData data) {
        return SQLJRTStatementToSQLMappingTracer.getSQL(statement);
    }

    public static String getSQL(Object resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = (ResultSetCreationRecord)sRTResultSetMap.get(resultSet)) != null) {
            return record.fSQL;
        }
        return null;
    }

    public static long getGeneratedTime(Object resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = (ResultSetCreationRecord)sRTResultSetMap.get(resultSet)) != null) {
            return record.fStartTime;
        }
        return 0L;
    }

    public static String getSQLType(Object resultSet) {
        ResultSetCreationRecord record;
        if (resultSet != null && (record = (ResultSetCreationRecord)sRTResultSetMap.get(resultSet)) != null) {
            return record.fSQLType;
        }
        return null;
    }

    public static Object getStatement(Object resultSet) {
        ResultSetCreationRecord rec = (ResultSetCreationRecord)sRTResultSetMap.get(resultSet);
        Object result = null;
        if (rec != null) {
            result = rec.fStatement;
        }
        return result;
    }

    private static final class ResultSetCreationRecord {
        public String fSQL;
        public String fSQLType;
        public long fStartTime;
        public Object fStatement;

        public ResultSetCreationRecord(String sql, String type, long time, Object stmt) {
            this.fSQL = sql;
            this.fSQLType = type;
            this.fStartTime = time;
            this.fStatement = stmt;
        }
    }
}

