/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.pools.hc2;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure3;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.pools.hc2.PoolContainer;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutableItem;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadPoolMonitor
implements ITimestampedRunnable {
    private static final PoolContainer tsArray = new PoolContainer();
    private static ThreadPoolMonitor instance = null;
    private static final char[] instanceLock = new char[0];
    private IAgent agent = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String BEGIN_METRIC_NAME = "WebMethods|Thread Pools|";
    private static final String USED_THREADS_METRIC_NAME = ":Used Threads";
    private static final String MAX_SIZE_THREAD_POOL_METRIC_NAME = ":Max Size";
    private static final String MIN_SIZE_THREAD_POOL_METRIC_NAME = ":Min Size";
    private Method objectPool_used = null;
    private Method objectPool_getMaxSize = null;
    private Method objectPool_getMinSize = null;
    private Method objectPool_getPoolName = null;
    private final AtomicReference<IRepository> fUsedRep = new AtomicReference();
    private final AtomicReference<IRepository> fMaxRep = new AtomicReference();
    private final AtomicReference<IRepository> fMinRep = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void noticeThreadPool(Object tmThreadPool) {
        String className;
        if (tmThreadPool == null || (className = tmThreadPool.getClass().getName()) == null || !"com.wm.app.b2b.server.TMThreadPool".equals(className)) return;
        char[] cArray = instanceLock;
        synchronized (instanceLock) {
            if (instance == null) {
                instance = new ThreadPoolMonitor(tmThreadPool.getClass().getClassLoader());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            tsArray.add(tmThreadPool);
            return;
        }
    }

    private ThreadPoolMonitor(ClassLoader tmThreadPoolClassLoader) {
        try {
            this.agent = AgentShim.getAgent();
            this.objectPool_used = this.getMethod("com.wm.util.pool.ObjectPool", "used", tmThreadPoolClassLoader);
            this.objectPool_getMaxSize = this.getMethod("com.wm.util.pool.ObjectPool", "getMaxSize", tmThreadPoolClassLoader);
            this.objectPool_getMinSize = this.getMethod("com.wm.util.pool.ObjectPool", "getMinSize", tmThreadPoolClassLoader);
            this.objectPool_getPoolName = this.getMethod("com.wm.util.pool.ObjectPool", "getPoolName", tmThreadPoolClassLoader);
            this.agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "WebMethods Thread Pool Monitor", true, 7500L, true);
            WMUtils.getLogger().info("WebMethods thread pool monitor started");
        }
        catch (Throwable t) {
            WMUtils.getLogger().error("Failed to start the WebMethods thread pool monitor", t);
        }
    }

    private Method getMethod(String className, String methodName, ClassLoader cl) throws ClassNotFoundException, NoSuchMethodException {
        Method method = null;
        Class<?> clazz = Class.forName(className, false, cl);
        method = clazz.getDeclaredMethod(methodName, EMPTY_CLASS_ARRAY);
        return method;
    }

    private void getThreadPoolMetrics() {
        Object[] array = tsArray.get();
        int i = 0;
        while (i < array.length) {
            String poolName;
            Object threadPool = array[i];
            if (threadPool != null && (poolName = this.getThreadPoolName(threadPool)) != null) {
                this.getThreadPoolUsedMetric(threadPool, this.objectPool_getMaxSize, BEGIN_METRIC_NAME + poolName + " #" + (i + 1) + MAX_SIZE_THREAD_POOL_METRIC_NAME);
                this.getThreadPoolMaxMetric(threadPool, this.objectPool_used, BEGIN_METRIC_NAME + poolName + " #" + (i + 1) + USED_THREADS_METRIC_NAME);
                this.getThreadPoolMinMetric(threadPool, this.objectPool_getMinSize, BEGIN_METRIC_NAME + poolName + " #" + (i + 1) + MIN_SIZE_THREAD_POOL_METRIC_NAME);
            }
            ++i;
        }
    }

    private String getThreadPoolName(Object threadPool) {
        String poolName = null;
        if (this.objectPool_getPoolName != null) {
            try {
                Object poolNameObject = this.objectPool_getPoolName.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (poolNameObject != null && poolNameObject instanceof String) {
                    poolName = (String)poolNameObject;
                    poolName = poolName.trim();
                    poolName = WMUtils.formatToBeResourceSafe(poolName);
                } else {
                    poolName = "UnknownPool";
                    WMUtils.getLogger().debug("In getThreadPoolName, assigned a default value to poolName: " + poolName);
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("Failed to get the name of the thread pool", e);
            }
            if (poolName != null && poolName.length() < 1) {
                poolName = null;
                WMUtils.getLogger().debug("In getThreadPoolName, poolName was empty, changing it to null");
            }
        } else {
            WMUtils.getLogger().debug("In getThreadPoolName: objectPool_getPoolName is null!");
        }
        return poolName;
    }

    private void getThreadPoolMetric(Object threadPool, Method method, String metricName) {
        if (method != null) {
            try {
                Object numberObject = method.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (numberObject != null && numberObject instanceof Integer) {
                    Integer numberInteger = (Integer)numberObject;
                    int numberInt = numberInteger;
                    IIntegerFluctuatingCounterDataAccumulator counter = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName);
                    if (!counter.IDataAccumulator_isShutOff()) {
                        counter.IIntegerCounterDataAccumulator_setValue(numberInt);
                    }
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("ThreadPoolMonitor: Failed to get the value for metric " + metricName, e);
            }
        }
    }

    private void getThreadPoolUsedMetric(Object threadPool, Method method, String metricName) {
        if (method != null) {
            try {
                Object numberObject = method.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (numberObject != null && numberObject instanceof Integer) {
                    CountMetricGathererWrapper wrapper;
                    SharedDataStructure3 newSize;
                    Integer numberInteger = (Integer)numberObject;
                    int numberInt = numberInteger;
                    AgentMetric usedMetric = this.agent.IAgent_getDataAccumulatorFactory().safeGetMetricOfType(metricName, 257, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
                    IRepository prevSize = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)usedMetric, (IRepository)(newSize = new SharedDataStructure3((ISharedElement)(wrapper = CountMetricGathererWrapper.getFactory((boolean)true)))));
                    if (prevSize != null) {
                        this.fUsedRep.set(prevSize);
                    } else {
                        this.fUsedRep.set((IRepository)newSize);
                    }
                    long startTime = 0L;
                    long endTime = 0L;
                    this.fUsedRep.get().update(BlamePointTracer.getNonCombiningUpdater(), (long)numberInt, startTime, endTime);
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("ThreadPoolMonitor: Failed to get the value for metric " + metricName, e);
            }
        }
    }

    private void getThreadPoolMaxMetric(Object threadPool, Method method, String metricName) {
        if (method != null) {
            try {
                Object numberObject = method.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (numberObject != null && numberObject instanceof Integer) {
                    CountMetricGathererWrapper wrapper;
                    SharedDataStructure3 newSize;
                    Integer numberInteger = (Integer)numberObject;
                    int numberInt = numberInteger;
                    AgentMetric maxMetric = this.agent.IAgent_getDataAccumulatorFactory().safeGetMetricOfType(metricName, 257, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
                    IRepository prevSize = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)maxMetric, (IRepository)(newSize = new SharedDataStructure3((ISharedElement)(wrapper = CountMetricGathererWrapper.getFactory((boolean)true)))));
                    if (prevSize != null) {
                        this.fMaxRep.set(prevSize);
                    } else {
                        this.fMaxRep.set((IRepository)newSize);
                    }
                    long startTime = 0L;
                    long endTime = 0L;
                    this.fMaxRep.get().update(BlamePointTracer.getNonCombiningUpdater(), (long)numberInt, startTime, endTime);
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("WMJDBCConnectionPoolMonitor: Failed to get the value for metric " + metricName, e);
            }
        } else {
            WMUtils.getLogger().debug("In getJDBCConnectionPoolMetric: the method object for metric " + metricName + " is null!");
        }
    }

    private void getThreadPoolMinMetric(Object threadPool, Method method, String metricName) {
        if (method != null) {
            try {
                Object numberObject = method.invoke(threadPool, EMPTY_OBJECT_ARRAY);
                if (numberObject != null && numberObject instanceof Integer) {
                    CountMetricGathererWrapper wrapper;
                    SharedDataStructure3 newSize;
                    Integer numberInteger = (Integer)numberObject;
                    int numberInt = numberInteger;
                    AgentMetric minMetric = this.agent.IAgent_getDataAccumulatorFactory().safeGetMetricOfType(metricName, 257, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
                    IRepository prevSize = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)minMetric, (IRepository)(newSize = new SharedDataStructure3((ISharedElement)(wrapper = CountMetricGathererWrapper.getFactory((boolean)true)))));
                    if (prevSize != null) {
                        this.fMinRep.set(prevSize);
                    } else {
                        this.fMinRep.set((IRepository)newSize);
                    }
                    long startTime = 0L;
                    long endTime = 0L;
                    this.fMinRep.get().update(BlamePointTracer.getNonCombiningUpdater(), (long)numberInt, startTime, endTime);
                }
            }
            catch (Throwable e) {
                WMUtils.getLogger().warn("WMJDBCConnectionPoolMonitor: Failed to get the value for metric " + metricName, e);
            }
        } else {
            WMUtils.getLogger().debug("In getJDBCConnectionPoolMetric: the method object for metric " + metricName + " is null!");
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        if (this.agent != null) {
            this.agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem((IExecutableItem)new ASimpleExecutableItem(){

                public void IExecutableItem_execute() {
                    ThreadPoolMonitor.this.getThreadPoolMetrics();
                }
            });
        }
    }
}

