/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.urlgrouper;

import com.wily.util.urlgrouper.UrlGroup;
import com.wily.util.urlgrouper.UrlGrouper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tree {
    private Node root = new Node("", null);

    public void addNode(String urlPath) {
        String[] pathSegments = Tree.parseList(urlPath, "/");
        Node curParent = this.root;
        int i = 0;
        while (i < pathSegments.length) {
            curParent = curParent.findOrAddChild(pathSegments[i]);
            ++i;
        }
    }

    public static String[] parseList(String list, String separators) {
        Vector<String> elements = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, separators);
        while (tokenizer.hasMoreTokens()) {
            elements.addElement(tokenizer.nextToken());
        }
        Object[] result = new String[elements.size()];
        elements.copyInto(result);
        return result;
    }

    public int getNumberOfNodesInLevel(int level) {
        return this.getUrlGroupsInLevel(level).length;
    }

    public UrlGroup[] getUrlGroupsInLevel(int level) {
        HashSet<Node> curNodes = new HashSet<Node>();
        curNodes.add(this.root);
        int i = 0;
        while (i < level) {
            HashSet newNodes = new HashSet();
            Iterator it = curNodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                newNodes.addAll(node.getAllKids());
            }
            curNodes = newNodes;
            ++i;
        }
        ArrayList<UrlGroup> answer = new ArrayList<UrlGroup>();
        Iterator it = curNodes.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            answer.add(new UrlGroup(UrlGrouper.sanitize(n.urlSegment), n.toString(), n.urlSegment));
        }
        return answer.toArray(new UrlGroup[0]);
    }

    private static class Node {
        public final Node parent;
        public final String urlSegment;
        public final HashMap children = new HashMap();

        public Node(String urlPath, Node parent) {
            this.urlSegment = urlPath;
            this.parent = parent;
        }

        public Node findOrAddChild(String childUrlSegment) {
            Node kid = (Node)this.children.get(childUrlSegment);
            if (kid == null) {
                kid = new Node(childUrlSegment, this);
                this.children.put(childUrlSegment, kid);
            }
            return kid;
        }

        public Set getAllKids() {
            return new HashSet(this.children.values());
        }

        public String toString() {
            String fullUrlPath = this.urlSegment;
            Node p = this.parent;
            while (p != null) {
                fullUrlPath = String.valueOf(p.urlSegment) + "/" + fullUrlPath;
                p = p.parent;
            }
            return fullUrlPath;
        }
    }
}

