/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.powerpack.webservices.extension.agent.trace.weblogic.WLS8StubImplTracer;
import java.lang.reflect.Method;

public class WLS8Formatter
extends ANameFormatter {
    public WLS8Formatter(IAgent agent) {
        super(agent);
    }

    public String getNamespace(InvocationData data) {
        Object stub = data.getInvocationObject();
        String namespaceURI = WLS8StubImplTracer.getNamespaceURI(stub);
        if (namespaceURI == null || namespaceURI.equals("")) {
            namespaceURI = this.getServiceName(data);
        }
        return (namespaceURI = WSMUtils.formatURLToBeResourceSafe(namespaceURI)).equals("UnknownService") ? "UnknownNamespace" : namespaceURI;
    }

    public String getOperationName(InvocationData data) {
        String name = null;
        try {
            Object operation = data.getInvocationParameterAsObject(0);
            name = WSMUtils.toString(operation);
        }
        catch (Throwable bomb) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", bomb);
        }
        return name == null || name.equals("") ? "UnknownOperationName" : name;
    }

    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object stub = data.getInvocationObject();
            try {
                Class<?> cl = stub.getClass();
                Method _getProperty = WSMUtils.find_GetPropertyWithStringArgMethod(cl);
                name = (String)_getProperty.invoke(stub, "javax.xml.rpc.service.endpoint.address");
            }
            catch (Throwable throwable) {
                Object url = WSMUtils.invokeMethodOnObject(stub, "_getTargetEndpoint");
                name = WSMUtils.toString(url);
            }
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null || name.equals("") ? "UnknownService" : name;
    }
}

