/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Constructor;

public class SEIStubSOAPCorrelationTracer
extends ASingleInstanceTracerFactory {
    private final IAgent agent;
    private IModuleFeedbackChannel logger = null;

    public SEIStubSOAPCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("SEIStubSOAPCorrelationTracer.ITracer_startTrace()");
        }
        try {
            Object objPacket = data.getInvocationParameterAsObject(0);
            Object message = WSMUtils.invokeMethodOnObject(objPacket, "getMessage");
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("SEIStubSOAPCorrelationTracer.ITracer_startTrace() message class " + message.getClass());
            }
            Object headers = WSMUtils.invokeMethodOnObject(message, "getHeaders");
            Object soapMessage = WSMUtils.invokeMethodOnObject(message, "readAsSOAPMessage");
            Object soapPart = WSMUtils.invokeMethodOnObject(soapMessage, "getSOAPPart");
            Object sOAPEnvelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
            Object attrName = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
            Object sOAPHeader = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "getHeader");
            if (sOAPHeader == null) {
                sOAPHeader = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "addHeader");
            }
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("SEIStubSOAPCorrelationTracer ITracer_startTrace correlationString  =" + correlationString);
            }
            Object sOAPElement = WSMUtils.invokeMethodOnObject(sOAPHeader, "addChildElement", new Class[]{String.class, String.class, String.class}, new Object[]{"WSCorIDSOAPHeader", "", "http://www.wilytech.com/"});
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            WSMUtils.invokeMethodOnObject(sOAPElement, "addAttribute", new Class[]{Class.forName("javax.xml.soap.Name", false, threadClassLoader), String.class}, new Object[]{attrName, correlationString});
            WSMUtils.invokeMethodOnObject(sOAPElement, "addNamespaceDeclaration", new Class[]{String.class, String.class}, new Object[]{"", "http://www.wilytech.com/"});
            Class<?> headerClass = Class.forName("com.sun.xml.ws.api.message.Header", false, threadClassLoader);
            Class<?> elementClass = Class.forName("org.w3c.dom.Element", false, threadClassLoader);
            Class<?> dOMHeaderClass = Class.forName("com.sun.xml.ws.message.DOMHeader", false, threadClassLoader);
            Constructor<?> dOMHeaderConstructor = dOMHeaderClass.getConstructor(elementClass);
            Object dOMHeader = dOMHeaderConstructor.newInstance(sOAPElement);
            WSMUtils.invokeMethodOnObject(headers, "add", new Class[]{headerClass}, new Object[]{dOMHeader});
        }
        catch (Exception e) {
            WSMUtils.handleException(this.agent, "SEIStubSOAPCorrelationTracer Error ", e);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
        if (!WSMUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        new CorrelationId().decrementCorrelationCount();
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

