/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.websphere;

import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.handlers.WsdmGenericHandler;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class WsdmWebSphereHandler
extends WsdmGenericHandler {
    private static final int HANDLER_TYPE_JAX_RPC_WEBSPHERE = 6;
    private static String HOST_NAME = "localhost";
    private static final String MC_HTTP_SERVLETREQUEST = "transport.http.servletRequest";
    private static final String MC_TRANSPORT_URL = "transport.url";
    private static final String MC_ENDPOINT_ADDRESS = "javax.xml.rpc.service.endpoint.address";
    private static final String MC_PRP_JMSREQUESTMESSAGE = "transport.jms.requestMessage";
    private static final String ENDPOINT_URL = "endpointURL";
    private static final String PATH = "path";

    private void getHostName() {
        if (HOST_NAME.equals("localhost")) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                HOST_NAME = address.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                log.error("WsdmWebSphereHandler::getHostName: UnknownHostException");
            }
        }
    }

    private String getTempPortWithMachineName(String tempPort) {
        int hostIndex = tempPort.indexOf("://");
        String finalPort = null;
        if (hostIndex == -1) {
            return tempPort;
        }
        String protocal = tempPort.substring(0, hostIndex += 3);
        String hostPort = tempPort.substring(hostIndex);
        String uri = "";
        if (hostPort.indexOf("/") == -1) {
            return tempPort;
        }
        hostPort = tempPort.substring(hostIndex, tempPort.indexOf(47, hostIndex));
        uri = tempPort.substring(tempPort.indexOf(47, hostIndex));
        String tempHost_Name = null;
        String port = null;
        if (hostPort.indexOf(58) != -1) {
            tempHost_Name = hostPort.substring(0, hostPort.indexOf(58));
            port = hostPort.substring(hostPort.indexOf(58));
        } else {
            tempHost_Name = hostPort;
        }
        if (tempHost_Name.equals("localhost") || tempHost_Name.equals("127.0.0.1")) {
            finalPort = port == null ? String.valueOf(protocal) + HOST_NAME + uri : String.valueOf(protocal) + HOST_NAME + port + uri;
        } else {
            return tempPort;
        }
        return finalPort;
    }

    public boolean handleFault(MessageContext context) {
        boolean ret;
        block2: {
            ret = true;
            try {
                ret = this.wsdmHandleFault(context);
            }
            catch (Throwable e) {
                log.error("WsdmWebSphereHandler::handleFault " + e);
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WsdmWebSphereHandler::handleFault " + WSMUtils.dumpStackTrace(e));
            }
        }
        return ret;
    }

    public boolean handleRequest(MessageContext context) {
        boolean ret;
        block2: {
            ret = super.handleRequest(context);
            try {
                ret = this.wsdmHandleRequest(context);
            }
            catch (Throwable e) {
                log.error("WsdmWebSphereHandler::handleRequest " + e);
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WsdmWebSphereHandler::handleRequest " + WSMUtils.dumpStackTrace(e));
            }
        }
        return ret;
    }

    public boolean handleResponse(MessageContext context) {
        boolean ret = true;
        try {
            this.wsdmHandleResponse(context);
        }
        catch (Throwable e) {
            log.error("WsdmWebSphereHandler::handleResponse " + e);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmWebSphereHandler::handleResponse " + WSMUtils.dumpStackTrace(e));
            }
            ret = true;
        }
        return ret;
    }

    public void init(HandlerInfo config) {
        block2: {
            try {
                this.wsdmInit(config);
            }
            catch (Throwable e) {
                log.error("WsdmWebSphereHandler::init " + e);
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WsdmWebSphereHandler::init " + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    private boolean wsdmHandleFault(MessageContext context) {
        WsdmMessageContext wsdmMessageContext;
        if (this.getObservationType() == 2) {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            if (log.isDebugLogging().booleanValue()) {
                log.debug("wsdmWebSphereHandler wsdmHandle correlationCount=" + correlationCount);
            }
        }
        if ((wsdmMessageContext = (WsdmMessageContext)context.getProperty("WSDM_TRANSID")) == null) {
            wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
        }
        if (wsdmMessageContext.getOperationNameSpace() == null || wsdmMessageContext.getOperationNameSpace().equals("")) {
            log.error("WsdmWebSphereHandler::wsdmHandleFault unable to get serviceName");
            return true;
        }
        if (wsdmMessageContext.getOperationName() == null || wsdmMessageContext.getOperationName().equals("")) {
            log.error("WsdmWebSphereHandler::wsdmHandleFault unable to get operationName");
            return true;
        }
        this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        if (wsdmMessageContext.getPortName() == null || wsdmMessageContext.getPortName().equals("")) {
            log.error("WsdmWebSphereHandler::wsdmHandleFault unable to get portName");
            return true;
        }
        SOAPMessage soapMess = ((com.ibm.ws.webservices.engine.MessageContext)context).getMessage();
        this.processSoapFault(soapMess, wsdmMessageContext);
        return true;
    }

    private void processCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope, String httpCorId) throws SOAPException {
        int observationType = wsdmMessageContext.getObservationType();
        if (observationType == 1) {
            boolean correlationIdFound = false;
            if (WSMUtils.correlationHTTPReadEnabled()) {
                if (httpCorId != null && !httpCorId.equals("")) {
                    new CorrelationId(httpCorId);
                    wsdmMessageContext.setCorrelationId(httpCorId);
                    correlationIdFound = true;
                } else if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler:processCorrelationId: Correlation ID over HTTP enabled but HTTP header is not available");
                }
            }
            if (WSMUtils.correlationSOAPReadEnabled() && !correlationIdFound) {
                if (envelope == null) {
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmWebSphereHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP header is not available");
                    }
                    return;
                }
                Name attrName = envelope.createName("CorID");
                SOAPHeader header = envelope.getHeader();
                if (header != null) {
                    Iterator itr = header.getChildElements();
                    while (itr.hasNext()) {
                        SOAPHeaderElement headerElement;
                        String headerName;
                        Object ChildElement = itr.next();
                        if (!(ChildElement instanceof SOAPHeaderElement) || !(headerName = (headerElement = (SOAPHeaderElement)ChildElement).getElementName().getLocalName()).equals("WSCorIDSOAPHeader")) continue;
                        correlationIdFound = true;
                        String correlationId = headerElement.getAttributeValue(attrName);
                        new CorrelationId(correlationId);
                        wsdmMessageContext.setCorrelationId(correlationId);
                        header.removeChild((Node)headerElement);
                        break;
                    }
                }
            }
            if (!correlationIdFound) {
                new CorrelationId();
            }
            return;
        }
        if (observationType == 2) {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmWebsphereHandler processcorrelationid::client");
            }
            this.processClientCorrelationId(wsdmMessageContext, envelope);
        } else if (observationType != 2) {
            log.error("WsdmWebsphereHandler::processCorrelationId: observationType is not set");
        }
    }

    private void processClientCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope) throws SOAPException {
        String correlationString = null;
        if (WSMUtils.correlationSOAPInsertionEnabled() || WSMUtils.correlationHTTPInsertionEnabled()) {
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            CorrelationId corrId = new CorrelationId();
            corrId.incrementSequenceId();
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmWebsphereHandler processcorrelationid::operationname=" + wsdmMessageContext.getOperationName() + " operationnamespace=" + wsdmMessageContext.getOperationNameSpace());
            }
            this.mapDependency();
            correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
            wsdmMessageContext.setCorrelationId(correlationString);
        }
        if (WSMUtils.correlationSOAPInsertionEnabled()) {
            if (envelope == null) {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP envolope is not available");
                }
                return;
            }
            this.processSOAPClientCorrelationId(envelope, correlationString);
        }
    }

    private void processSOAPClientCorrelationId(SOAPEnvelope envelope, String correlationString) {
        block3: {
            try {
                SOAPHeader header = envelope.getHeader();
                Name attrName = envelope.createName("CorID");
                SOAPHeaderElement headerElement = (SOAPHeaderElement)header.addChildElement("WSCorIDSOAPHeader", "", "http://www.wilytech.com/");
                headerElement.addAttribute(attrName, correlationString);
                headerElement.addNamespaceDeclaration("", "http://www.wilytech.com/");
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler::element=" + headerElement);
                }
            }
            catch (SOAPException se) {
                log.error("WsdmWebSphereHandler::setCorrelationIdInHeader cannot set header " + (Object)((Object)se));
                if (!log.isDebugLogging().booleanValue()) break block3;
                log.debug("WsdmWebSphereHandler::setCorrelationIdInHeader " + WSMUtils.dumpStackTrace(se));
            }
        }
    }

    private boolean wsdmHandleRequest(MessageContext context) {
        block58: {
            PortDesc servDesc;
            OperationDesc opDesc;
            SOAPBody sb;
            SOAPEnvelope se;
            Message msg;
            String httpCorId;
            WsdmMessageContext wsdmMessageContext;
            String serviceName;
            String operationNamespace;
            block56: {
                operationNamespace = "";
                serviceName = "";
                wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
                httpCorId = null;
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler::wsdmHandleRequest");
                }
                HttpServletRequest req = null;
                msg = null;
                if (context.containsProperty(MC_HTTP_SERVLETREQUEST)) {
                    req = (HttpServletRequest)context.getProperty(MC_HTTP_SERVLETREQUEST);
                } else if (context.containsProperty(MC_PRP_JMSREQUESTMESSAGE)) {
                    msg = (Message)context.getProperty(MC_PRP_JMSREQUESTMESSAGE);
                }
                Object objReqHeaders = context.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
                if (objReqHeaders instanceof HashMap) {
                    HashMap requestheaders = (HashMap)objReqHeaders;
                    Set keyset = requestheaders.keySet();
                    for (Object key : keyset) {
                        Object value = requestheaders.get(key);
                        if (!log.isDebugLogging().booleanValue()) continue;
                        log.debug("com.ibm.websphere.webservices.requestTransportProperties properties: " + key + ":" + value);
                    }
                }
                String tempPort = null;
                if (req == null && msg == null) {
                    if (context.containsProperty(MC_ENDPOINT_ADDRESS)) {
                        tempPort = (String)context.getProperty(MC_ENDPOINT_ADDRESS);
                    } else if (context.containsProperty(MC_TRANSPORT_URL)) {
                        tempPort = (String)context.getProperty(MC_TRANSPORT_URL);
                    }
                    wsdmMessageContext.setServiceName(tempPort);
                    if ((tempPort == null || tempPort.equals("")) && log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmWebSphereHandler::wsdmHandleRequest unable to get HttpServletRequest");
                    }
                    wsdmMessageContext.setRequestorLocation(this.wsdmHandlerUtil.getObserverIp());
                }
                if (req != null) {
                    httpCorId = req.getHeader("CorID");
                    if (context.containsProperty(PATH)) {
                        serviceName = (String)context.getProperty(PATH);
                        wsdmMessageContext.setServiceName(serviceName);
                    }
                    String tempHostName = req.getServerName();
                    if (req.getServerPort() == 80) {
                        wsdmMessageContext.setPortName("http://" + tempHostName + req.getRequestURI());
                    } else {
                        wsdmMessageContext.setPortName("http://" + tempHostName + ":" + req.getServerPort() + req.getRequestURI());
                    }
                    wsdmMessageContext.setRequestorLocation(req.getRemoteAddr());
                } else if (msg != null) {
                    try {
                        String portname = msg.getStringProperty(ENDPOINT_URL);
                        wsdmMessageContext.setPortName(portname);
                    }
                    catch (JMSException jMSException) {
                        log.info("WsdmWebSphereHandler::wsdmHandleRequest unable to read endpointURL of Jms request");
                    }
                } else {
                    wsdmMessageContext.setPortName(tempPort);
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler::wsdmHandleRequest: portName=" + wsdmMessageContext.getPortName());
                    log.debug("WsdmWebSphereHandler::wsdmHandleRequest: requestorLocation=" + wsdmMessageContext.getRequestorLocation());
                }
                SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
                wsdmMessageContext.setRequestSOAPMessage(soapMess);
                se = null;
                SOAPPart sp = null;
                sb = null;
                try {
                    if (soapMess != null) {
                        sp = soapMess.getSOAPPart();
                        if (sp != null) {
                            se = sp.getEnvelope();
                        }
                    } else {
                        log.error("WsdmWebSphereHandler::wsdmHandleRequest: SoapMess is null");
                    }
                }
                catch (SOAPException e) {
                    log.error("WsdmWebSphereHandler::wsdmHandleRequest: " + (Object)((Object)e));
                    if (!log.isDebugLogging().booleanValue()) break block56;
                    log.debug("WsdmWebSphereHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(e));
                }
            }
            if ((opDesc = ((com.ibm.ws.webservices.engine.MessageContext)context).getOperation()) != null) {
                wsdmMessageContext.setOperationName(opDesc.getName());
                QName opqname = opDesc.getElementQName();
                if (opqname != null) {
                    if (wsdmMessageContext.getOperationName() == null || wsdmMessageContext.getOperationName().equals("")) {
                        wsdmMessageContext.setOperationName(opqname.getLocalPart());
                    }
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmWebSphereHandler::wsdmHandleRequest:  opQName = " + opqname.toString());
                        log.debug("WsdmWebSphereHandler::wsdmHandleRequest:  opQName namespaceURI= " + opqname.getNamespaceURI());
                        log.debug("WsdmWebSphereHandler::wsdmHandleRequest:  opQName localPart= " + opqname.getLocalPart());
                    }
                    operationNamespace = opqname.getNamespaceURI();
                }
            }
            if (operationNamespace == null || operationNamespace.equals("")) {
                String inputString = "";
                if (se != null) {
                    block57: {
                        try {
                            sb = se.getBody();
                        }
                        catch (SOAPException soape) {
                            log.error("WsdmWebSphereHandler::wsdmHandleRequest: " + (Object)((Object)soape));
                            if (!log.isDebugLogging().booleanValue()) break block57;
                            log.debug("WsdmWebSphereHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(soape));
                        }
                    }
                    if (sb != null) {
                        try {
                            inputString = sb.toString();
                        }
                        catch (Exception e) {
                            log.debug("WsdmWebSphereHandler::wsdmHandleRequest: Exception=" + e.getMessage());
                        }
                    }
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WsdmWebSphereHandler::wsdmHandleRequest: calling getOperationNamespaceFromSoapBody");
                }
                try {
                    operationNamespace = this.getOperationNamespaceFromSoapBody(inputString);
                }
                catch (Exception exception) {}
            }
            try {
                if (msg != null && opDesc != null && (servDesc = opDesc.getParent()) != null) {
                    serviceName = servDesc.getName();
                    wsdmMessageContext.setServiceName(serviceName);
                }
            }
            catch (Exception exception) {}
            try {
                if (operationNamespace == null || operationNamespace.equals("") || operationNamespace.equals(" ")) {
                    if (msg == null && opDesc != null) {
                        servDesc = opDesc.getParent();
                        if (servDesc != null) {
                            operationNamespace = servDesc.getName();
                        }
                    } else {
                        operationNamespace = serviceName;
                    }
                }
            }
            catch (Exception exception) {}
            try {
                if (operationNamespace == null || operationNamespace.equals("") || operationNamespace.equals(" ")) {
                    operationNamespace = wsdmMessageContext.getPortName();
                }
            }
            catch (Exception exception) {}
            try {
                wsdmMessageContext.setOperationNameSpace(operationNamespace);
                this.wsdmHandlerUtil.observeRequest(wsdmMessageContext);
            }
            catch (Exception exception) {}
            context.setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
            try {
                this.processCorrelationId(wsdmMessageContext, se, httpCorId);
            }
            catch (SOAPException e) {
                log.error("WsdmWebSphereHandler::wsdmHandleRequest: " + (Object)((Object)e));
                if (!log.isDebugLogging().booleanValue()) break block58;
                log.debug("WsdmWebSphereHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    protected WsdmMessageContext wsdmHandleResponse(MessageContext context) {
        if (this.getObservationType() == 2) {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            if (log.isDebugLogging().booleanValue()) {
                log.debug("wsdmWebSphereHandler wsdmHandleResponse correlationCount=" + correlationCount);
            }
        }
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmWebSphereHandler::wsdmHandleResponse");
        }
        WsdmMessageContext wsdmMessageContext = this.setupTransactionId(context);
        SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
        wsdmMessageContext.setResponseSOAPMessage(soapMess);
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmWebSphereHandler::wsdmHandleResponse: port is " + wsdmMessageContext.getPortName());
        }
        this.wsdmHandlerUtil.observeResponse(wsdmMessageContext);
        return wsdmMessageContext;
    }

    public boolean hasSOAPHeader(MessageContext context, String headerName) {
        boolean headerFound;
        block4: {
            SOAPEnvelope envelope = null;
            SOAPPart sp = null;
            headerFound = false;
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                if (soapMess != null) {
                    SOAPHeader header;
                    sp = soapMess.getSOAPPart();
                    if (sp == null || (header = (envelope = sp.getEnvelope()).getHeader()) == null) break block4;
                    Iterator it = header.examineHeaderElements("http://www.wilytech.com/");
                    while (it.hasNext()) {
                        SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                        String hdrName = headerElement.getElementName().getLocalName();
                        if (!hdrName.equals(headerName)) continue;
                        headerFound = true;
                        break block4;
                    }
                    break block4;
                }
                log.error("WsdmWebSphereHandler::hasSOAPHeader: SoapMess is null");
            }
            catch (SOAPException e) {
                log.error("WsdmWebSphereHandler::hasSOAPHeader: " + (Object)((Object)e));
                if (!log.isDebugLogging().booleanValue()) break block4;
                log.debug("WsdmWebSphereHandler::hasSOAPHeader: " + WSMUtils.dumpStackTrace(e));
            }
        }
        return headerFound;
    }

    public void addSOAPHeader(MessageContext context, String headerName) {
        block6: {
            SOAPEnvelope envelope = null;
            SOAPPart sp = null;
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                if (soapMess != null) {
                    sp = soapMess.getSOAPPart();
                    if (sp != null) {
                        boolean headerFound = false;
                        headerFound = this.hasSOAPHeader(context, headerName);
                        if (!headerFound) {
                            envelope = sp.getEnvelope();
                            SOAPHeader header = envelope.getHeader();
                            SOAPHeaderElement headerElement = (SOAPHeaderElement)header.addChildElement(headerName, "", "http://www.wilytech.com/");
                            headerElement.addTextNode("WSDM_TRUE");
                            headerElement.setActor("http://www.wilytech.com/");
                        }
                    }
                } else {
                    log.error("WsdmWebSphereHandler::addSOAPHeader: SoapMess is null");
                }
            }
            catch (SOAPException e) {
                log.error("WsdmWebSphereHandler::addSOAPHeader: " + (Object)((Object)e));
                if (!log.isDebugLogging().booleanValue()) break block6;
                log.debug("WsdmWebSphereHandler::addSOAPHeader: " + WSMUtils.dumpStackTrace(e));
            }
        }
    }
}

