/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QMVO;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.WeakHashMap;

public final class QMRepository
implements Kconstants {
    private static final String CLASS_NAME = "QMRepository.";
    private static Map qmVOsMap = new WeakHashMap();
    private static final Object MUTEX_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QMVO getQMVO(Object qmObj) {
        QMVO qmvo = null;
        if (qmObj != null && (qmvo = (QMVO)qmVOsMap.get(qmObj)) == null && (qmvo = QMRepository.createQMVO(qmObj)) != null) {
            Object object = MUTEX_LOCK;
            synchronized (object) {
                QMVO qmvo1 = (QMVO)qmVOsMap.get(qmObj);
                if (qmvo1 == null) {
                    qmVOsMap.put(qmObj, qmvo);
                } else {
                    qmvo = qmvo1;
                }
            }
        }
        return qmvo;
    }

    private static QMVO createQMVO(Object qmgrObject) {
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.createQMVO(qmgrObject) entry");
        QMVO qmvo = new QMVO();
        String qmName = CAQueueManagerUtils.getQMName(qmgrObject);
        if (qmName != null && qmName.length() != 0) {
            qmvo.setQMName(qmName);
        }
        StringBuffer hostName = new StringBuffer();
        StringBuffer port = new StringBuffer();
        QMRepository.getHosNameAndPort(qmgrObject, hostName, port);
        String reslovedHostName = QMRepository.resolveLocalHost(hostName.toString());
        qmvo.setHostName(reslovedHostName);
        try {
            qmvo.setPort(new Integer(port.toString()));
        }
        catch (Exception exception) {}
        String channelName = QMRepository.getChannel(qmgrObject);
        if (channelName != null && channelName.length() != 0) {
            qmvo.setChannelName(channelName);
        }
        int ccsid = QMRepository.getCCSID(qmgrObject);
        qmvo.setCcsid(ccsid);
        return qmvo;
    }

    private static void getHosNameAndPort(Object qmgrObj, StringBuffer hostName, StringBuffer port) {
        try {
            hostName.append(CAMQUtils.getPropertyMQQueueManager(qmgrObj, "hostname"));
            port.append(CAMQUtils.getPropertyMQQueueManager(qmgrObj, "port"));
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getHostName(Object) ", (Throwable)e);
        }
    }

    private static String getHostName(Object qmgrObj) {
        String hostName = "";
        try {
            hostName = CAMQUtils.getPropertyMQQueueManager(qmgrObj, "hostname");
            hostName = QMRepository.resolveLocalHost(hostName);
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getHostName(Object) ", (Throwable)e);
        }
        return hostName.toLowerCase();
    }

    private static String resolveLocalHost(String hostName) {
        String resloveHostName = null;
        if (hostName == null || (hostName = hostName.trim()).length() == 0) {
            resloveHostName = HOST_UNKNOWN;
        } else if (hostName.equals("localhost") || hostName.equals("127.0.0.1")) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                MQPPLog.getLogger().error(MQPPLog.getModule(), "QMRepository:resolveLocalHost:Exception: " + e.getMessage());
                MQPPLog.getLogger().debug((Throwable)e);
            }
            resloveHostName = addr.getHostName().trim();
        } else {
            resloveHostName = hostName.trim();
        }
        return resloveHostName;
    }

    private static int getPort(Object qmgrObj) {
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getPort(qmgrObj)entry");
        int port = -1;
        try {
            String portNumber = CAMQUtils.getPropertyMQQueueManager(qmgrObj, "port");
            if (portNumber != null && portNumber.trim().length() != 0) {
                port = Integer.parseInt(portNumber);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getPort(qmgrObj)", (Throwable)e);
        }
        return port;
    }

    private static String getChannel(Object qmgrObj) {
        String channel = "";
        try {
            channel = CAMQUtils.getPropertyMQQueueManager(qmgrObj, "channel");
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getChannel(qmgrObj)", (Throwable)e);
        }
        return channel;
    }

    private static int getCCSID(Object qmgrObj) {
        int ccsid = -1;
        try {
            String ccsidValue = CAMQUtils.getPropertyMQQueueManager(qmgrObj, "CCSID");
            if (ccsidValue != null && ccsidValue.trim().length() != 0) {
                ccsid = Integer.parseInt(ccsidValue);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "QMRepository.getCCSID(qmgrObj)", (Throwable)e);
        }
        return ccsid;
    }
}

