/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.wilyassert.Assertion;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;

public class DelegatingClassLoader
extends SecureClassLoader {
    private static final Permissions sPermissions = new Permissions();
    private ClassLoader[] delegateLoaders = new ClassLoader[0];

    protected PermissionCollection getPermissions(CodeSource codesource) {
        return sPermissions;
    }

    public DelegatingClassLoader(ClassLoader[] delegates) {
        this.init(delegates);
    }

    public DelegatingClassLoader(ClassLoader parentClassLoader, ClassLoader[] delegates) {
        super(parentClassLoader);
        this.init(delegates);
    }

    public void setClassLoaders(ClassLoader[] delegates) {
        this.init(delegates);
    }

    private void init(ClassLoader[] delegates) {
        if (delegates != null && delegates.length > 0) {
            this.delegateLoaders = new ClassLoader[delegates.length];
            System.arraycopy(delegates, 0, this.delegateLoaders, 0, delegates.length);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (int i = 0; i < this.delegateLoaders.length; ++i) {
            try {
                if (this.delegateLoaders[i] != null) {
                    clazz = this.delegateLoaders[i].loadClass(name);
                }
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        Assertion.wilyAssert(clazz == null);
        throw new ClassNotFoundException("Class " + name + "not found");
    }

    protected URL findResource(String name) {
        URL resource = null;
        for (int i = 0; i < this.delegateLoaders.length; ++i) {
            if (this.delegateLoaders[i] != null) {
                resource = this.delegateLoaders[i].getResource(name);
            }
            if (resource == null) continue;
            return resource;
        }
        return resource;
    }

    static {
        sPermissions.add(new AllPermission());
    }
}

