/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.linking;

import com.wily.ui.linking.IHyperlinkNavigatorItem;
import com.wily.ui.linking.ILinkTarget;
import com.wily.ui.swing.WilyButtonComboBoxModel;
import com.wily.wilyassert.Assertion;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class HyperlinkNavigator {
    private static final int kMaxBackwardStackSize = 80;
    private static final int kMaxComboListSize = 9;
    private HelpfulStack fBackwardStack = new HelpfulStack();
    private HelpfulStack fForewardStack = new HelpfulStack();
    private WilyButtonComboBoxModel fBackwardBCBModel = new HyperlinkBCBModel(this.fBackwardStack, this.fForewardStack);
    private WilyButtonComboBoxModel fForwardBCBModel = new HyperlinkBCBModel(this.fForewardStack, this.fBackwardStack);
    private ILinkTarget fLinkTarget;
    private IHyperlinkNavigatorItem fCurrentObject;
    private boolean fIsCurrentlyNavigating;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public HyperlinkNavigator(ILinkTarget linkTarget, String backwardActionName, String forewardActionName) {
        Assertion.wilyAssert(linkTarget != null);
        this.fLinkTarget = linkTarget;
        this.fCurrentObject = null;
    }

    public synchronized void setCurrentHyperlinkNavigatorItem(IHyperlinkNavigatorItem navigatorItem) {
        if (this.fIsCurrentlyNavigating) {
            return;
        }
        Assertion.wilyAssert(navigatorItem != null);
        if (this.fCurrentObject != null && this.fCurrentObject.equals(navigatorItem)) {
            return;
        }
        if (this.fCurrentObject != null) {
            this.fBackwardStack.push(this.fCurrentObject);
        }
        this.fForewardStack.removeAllElements();
        this.trimStackIfNecessary();
        this.fCurrentObject = navigatorItem;
    }

    public synchronized boolean gotoHyperlinkNavigatorItem(IHyperlinkNavigatorItem hyperlinkNavigatorItem) {
        if ((hyperlinkNavigatorItem = this.fLinkTarget.displayHyperlinkNavigatorItem(hyperlinkNavigatorItem)) != null) {
            this.setCurrentHyperlinkNavigatorItem(hyperlinkNavigatorItem);
        }
        return hyperlinkNavigatorItem != null;
    }

    public synchronized void reset() {
        this.fBackwardStack.removeAllElements();
        this.fForewardStack.removeAllElements();
        this.fCurrentObject = null;
    }

    public synchronized boolean isEmpty() {
        return this.fCurrentObject == null && this.fBackwardStack.isEmpty() && this.fForewardStack.isEmpty();
    }

    public WilyButtonComboBoxModel getBackwardBCBModel() {
        return this.fBackwardBCBModel;
    }

    public WilyButtonComboBoxModel getForwardBCBModel() {
        return this.fForwardBCBModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doMainButtonAction(Stack buttonStack, Stack otherStack) {
        try {
            IHyperlinkNavigatorItem item;
            this.fIsCurrentlyNavigating = true;
            IHyperlinkNavigatorItem iHyperlinkNavigatorItem = item = buttonStack.size() > 0 ? (IHyperlinkNavigatorItem)buttonStack.pop() : null;
            if (item != null && item.isValid() && (item = this.fLinkTarget.displayHyperlinkNavigatorItem(item)) != null) {
                otherStack.push(this.fCurrentObject);
                this.fCurrentObject = item;
            }
            this.trimStackIfNecessary();
        }
        finally {
            this.fIsCurrentlyNavigating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doComboSelectionAction(IHyperlinkNavigatorItem item, Stack buttonStack, Stack otherStack) {
        try {
            this.fIsCurrentlyNavigating = true;
            if (item == null || !item.isValid()) {
                return;
            }
            if ((item = this.fLinkTarget.displayHyperlinkNavigatorItem(item)) != null) {
                boolean bContinue = true;
                IHyperlinkNavigatorItem nextItem = null;
                while (bContinue) {
                    try {
                        nextItem = (IHyperlinkNavigatorItem)buttonStack.pop();
                    }
                    catch (EmptyStackException e) {
                        nextItem = null;
                    }
                    if (nextItem != null) {
                        otherStack.push(this.fCurrentObject);
                        this.fCurrentObject = nextItem;
                        if (!nextItem.equals(item)) continue;
                        bContinue = false;
                        continue;
                    }
                    bContinue = false;
                }
            }
            this.trimStackIfNecessary();
        }
        finally {
            this.fIsCurrentlyNavigating = false;
        }
    }

    protected void trimStackIfNecessary() {
        Assertion.wilyAssert(this.fBackwardStack.size() <= 81);
        while (this.fBackwardStack.size() > 80) {
            this.fBackwardStack.removeElementAt(0);
        }
    }

    private class StackComboModel
    implements ComboBoxModel {
        Stack fStack;
        int fLastSize;
        Object fSelectedItem;
        EventListenerList fListenerList = new EventListenerList();

        public StackComboModel(HelpfulStack theStack) {
            this.fStack = theStack;
            this.fLastSize = this.fStack.size();
            theStack.addHelpfulStackListener(new HelpfulStackListener(){

                public void stackChanged() {
                    int newSize = StackComboModel.this.fStack.size();
                    if (newSize < StackComboModel.this.fLastSize) {
                        StackComboModel.this.fireIntervalRemoved(StackComboModel.this, newSize, StackComboModel.this.fLastSize - 1);
                    } else if (newSize > StackComboModel.this.fLastSize) {
                        StackComboModel.this.fireIntervalAdded(StackComboModel.this, StackComboModel.this.fLastSize, newSize - 1);
                    }
                    if (newSize > 0) {
                        StackComboModel.this.fireContentsChanged(StackComboModel.this, 0, newSize - 1);
                    }
                    StackComboModel.this.fLastSize = newSize;
                }
            });
        }

        public int getSize() {
            return Math.min(this.fStack.size(), 9);
        }

        public Object getElementAt(int index) {
            int indexToReturn = this.fStack.size() - index - 1;
            return this.fStack.get(indexToReturn);
        }

        public void setSelectedItem(Object anItem) {
            this.fSelectedItem = anItem;
        }

        public Object getSelectedItem() {
            return this.fSelectedItem;
        }

        public void addListDataListener(ListDataListener l) {
            this.fListenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = HyperlinkNavigator.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.fListenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = HyperlinkNavigator.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
        }

        protected void fireContentsChanged(Object source, int index0, int index1) {
            EventListener[] listeners = this.fListenerList.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = HyperlinkNavigator.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
            ListDataEvent e = null;
            for (int i = 0; i < listeners.length; ++i) {
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ListDataListener listener = (ListDataListener)listeners[i];
                listener.contentsChanged(e);
            }
        }

        protected void fireIntervalAdded(Object source, int index0, int index1) {
            EventListener[] listeners = this.fListenerList.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = HyperlinkNavigator.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
            ListDataEvent e = null;
            for (int i = 0; i < listeners.length; ++i) {
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ListDataListener listener = (ListDataListener)listeners[i];
                listener.intervalAdded(e);
            }
        }

        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            EventListener[] listeners = this.fListenerList.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = HyperlinkNavigator.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
            ListDataEvent e = null;
            for (int i = 0; i < listeners.length; ++i) {
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ListDataListener listener = (ListDataListener)listeners[i];
                listener.intervalRemoved(e);
            }
        }
    }

    private class HelpfulStack
    extends Stack {
        private static final long serialVersionUID = -5495161209101867258L;
        EventListenerList fListenerList = new EventListenerList();

        private HelpfulStack() {
        }

        public void addHelpfulStackListener(HelpfulStackListener l) {
            this.fListenerList.add(class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener == null ? (class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener = HyperlinkNavigator.class$("com.wily.ui.linking.HyperlinkNavigator$HelpfulStackListener")) : class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener, l);
        }

        public void removeHelpfulStackListener(HelpfulStackListener l) {
            this.fListenerList.add(class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener == null ? (class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener = HyperlinkNavigator.class$("com.wily.ui.linking.HyperlinkNavigator$HelpfulStackListener")) : class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener, l);
        }

        protected void fireStackChanged() {
            EventListener[] listeners = this.fListenerList.getListeners(class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener == null ? (class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener = HyperlinkNavigator.class$("com.wily.ui.linking.HyperlinkNavigator$HelpfulStackListener")) : class$com$wily$ui$linking$HyperlinkNavigator$HelpfulStackListener);
            for (int i = 0; i < listeners.length; ++i) {
                HelpfulStackListener listener = (HelpfulStackListener)listeners[i];
                listener.stackChanged();
            }
        }

        public synchronized void removeElementAt(int index) {
            super.removeElementAt(index);
            this.fireStackChanged();
        }

        public synchronized Object remove(int index) {
            Object o = super.remove(index);
            this.fireStackChanged();
            return o;
        }

        public synchronized boolean removeAll(Collection c) {
            boolean b = super.removeAll(c);
            this.fireStackChanged();
            return b;
        }

        public synchronized void removeAllElements() {
            super.removeAllElements();
            this.fireStackChanged();
        }

        protected void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
            this.fireStackChanged();
        }

        public synchronized boolean retainAll(Collection c) {
            boolean b = super.retainAll(c);
            this.fireStackChanged();
            return b;
        }

        public synchronized void setSize(int newSize) {
            super.setSize(newSize);
            this.fireStackChanged();
        }

        public synchronized void addElement(Object obj) {
            super.addElement(obj);
            IHyperlinkNavigatorItem item = (IHyperlinkNavigatorItem)obj;
            Object itemInside = item.getItem();
            this.fireStackChanged();
        }

        public synchronized boolean addAll(Collection c) {
            boolean b = super.addAll(c);
            this.fireStackChanged();
            return b;
        }

        public synchronized boolean addAll(int index, Collection c) {
            boolean b = super.addAll(index, c);
            this.fireStackChanged();
            return b;
        }

        public synchronized boolean add(Object o) {
            boolean b = super.add(o);
            this.fireStackChanged();
            return b;
        }

        public synchronized void insertElementAt(Object obj, int index) {
            super.insertElementAt(obj, index);
            this.fireStackChanged();
        }

        public synchronized Object set(int index, Object element) {
            Object o = super.set(index, element);
            this.fireStackChanged();
            return o;
        }

        public synchronized void setElementAt(Object obj, int index) {
            super.setElementAt(obj, index);
            this.fireStackChanged();
        }
    }

    private static interface HelpfulStackListener
    extends EventListener {
        public void stackChanged();
    }

    private class HyperlinkBCBModel
    implements WilyButtonComboBoxModel {
        HelpfulStack fThisStack;
        HelpfulStack fOtherStack;
        EventListenerList fListenerList;
        StackComboModel fStackComboModel;
        boolean fLastWasEnabled;

        HyperlinkBCBModel(HelpfulStack thisStack, HelpfulStack otherStack) {
            this.fThisStack = thisStack;
            this.fOtherStack = otherStack;
            this.fListenerList = new EventListenerList();
            this.fLastWasEnabled = this.fThisStack.size() != 0;
            this.fThisStack.addHelpfulStackListener(new HelpfulStackListener(){

                public void stackChanged() {
                    HyperlinkBCBModel.this.fireEnabledStateChangedIfNecessary();
                }
            });
            this.fStackComboModel = new StackComboModel(this.fThisStack);
        }

        public boolean isEnabled() {
            return this.fThisStack.size() != 0;
        }

        public void addEnabledChangeListener(PropertyChangeListener l) {
            this.fListenerList.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = HyperlinkNavigator.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        }

        public void removeEnabledChangeListener(PropertyChangeListener l) {
            this.fListenerList.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = HyperlinkNavigator.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
        }

        public void aboutToPopupComboBox() {
            Iterator iterator = this.fThisStack.iterator();
            while (iterator.hasNext()) {
                IHyperlinkNavigatorItem nextItem = (IHyperlinkNavigatorItem)iterator.next();
                if (nextItem.isValid()) continue;
                iterator.remove();
            }
        }

        private void fireEnabledStateChangedIfNecessary() {
            boolean currentEnabled;
            boolean bl = currentEnabled = this.fThisStack.size() != 0;
            if (currentEnabled != this.fLastWasEnabled) {
                this.fLastWasEnabled = currentEnabled;
                this.fireEnabledStateChanged(new Boolean(!currentEnabled), new Boolean(currentEnabled));
            }
        }

        private void fireEnabledStateChanged(Object oldValue, Object newValue) {
            EventListener[] listeners = this.fListenerList.getListeners(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = HyperlinkNavigator.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
            for (int i = 0; i < listeners.length; ++i) {
                PropertyChangeListener listener = (PropertyChangeListener)listeners[i];
                listener.propertyChange(new PropertyChangeEvent(this, "enabled", oldValue, newValue));
            }
        }

        public void performDefaultAction() {
            HyperlinkNavigator.this.doMainButtonAction(this.fThisStack, this.fOtherStack);
        }

        public void performSelectionAction(Object selectedObject) {
            if (selectedObject != null) {
                IHyperlinkNavigatorItem navigatorItem = (IHyperlinkNavigatorItem)selectedObject;
                HyperlinkNavigator.this.doComboSelectionAction(navigatorItem, this.fThisStack, this.fOtherStack);
            }
        }

        public ComboBoxModel getComboBoxModel() {
            return this.fStackComboModel;
        }
    }
}

