/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.NoticeFieldAssignmentTransformationBuilder;
import com.wily.util.classfile.IClassName;

public final class NoticeFieldAssignmentIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final IClassName fEventNoticingClass;
    private final FlagName fScopeFlagName;

    public NoticeFieldAssignmentIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IClassName eventNoticingClass) throws InvalidDirectiveException {
        this(source, lineNumber, flagName, eventNoticingClass, null);
    }

    public NoticeFieldAssignmentIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IClassName eventNoticingClass, FlagName scopeFlagName) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fEventNoticingClass = eventNoticingClass;
        this.fScopeFlagName = scopeFlagName;
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IClassName getEventNoticingClass() {
        return this.fEventNoticingClass;
    }

    private FlagName getScopeFlagName() {
        return this.fScopeFlagName;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroup = builder.getTracerGroupBuilder(this.getFlagName());
        tracerGroup.setNameMatchingOnly();
        TracerGroupBuilder scopeTracerGroup = this.getScopeFlagName() == null ? null : builder.getTracerGroupBuilder(this.getScopeFlagName());
        builder.addTransformation(new NoticeFieldAssignmentTransformationBuilder(tracerGroup, this.getEventNoticingClass(), scopeTracerGroup));
    }
}

