/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionBroker;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionBroker;
import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.NullExtensionLocator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;

public final class ExtensionAdministrator {
    private static final String kAgentExtensionType = "Introscope-Agent";
    private final IAgent fAgent;
    private final ExtendedFile fAgentExtensionDirectory;
    private final IExtensionBroker fBroker;

    public ExtensionAdministrator(IAgent agent, IExtensionLocatorPolicy policy) {
        Assertion.wilyAssert(false);
        this.fAgent = agent;
        this.fAgentExtensionDirectory = this.findExtensionDirectory(agent);
        IExtensionLocator locator = this.createExtensionLocator(policy, this.fAgentExtensionDirectory);
        Assertion.wilyAssert(false);
        this.fBroker = AInstrumentationHelper.isValidate() ? new ExtensionBroker(ExtensionAdministrator.class.getClassLoader(), new IExtensionLocator[]{locator}, this.getModuleFeedback(), this.getStringLocalizer(), AInstrumentationHelper.getValidationFeedbackChannel(), agent.IAgent_getIndexedProperties()) : new ExtensionBroker(ExtensionAdministrator.class.getClassLoader(), new IExtensionLocator[]{locator}, this.getModuleFeedback(), this.getStringLocalizer(), null, agent.IAgent_getIndexedProperties());
        ((ExtensionBroker)this.fBroker).loadExtensions(new String[]{kAgentExtensionType, "Eclipse-Plugin"});
        this.logExtensionVersions();
    }

    private final IAgent getAgent() {
        return this.fAgent;
    }

    private final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private final ExtendedFile findExtensionDirectory(IAgent agent) {
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Looking_For_Directory_Key", "introscope.agent.extensions.directory"));
        String directoryProperty = (String)agent.IAgent_getIndexedProperties().get("introscope.agent.extensions.directory");
        if (directoryProperty == null || directoryProperty.equals("")) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Property_Not_Configured", "introscope.agent.extensions.directory"));
            return null;
        }
        ExtendedFile extensionDirectory = null;
        if (ExtendedFile.isAbsolutePath(directoryProperty)) {
            extensionDirectory = new ExtendedFile(directoryProperty);
        } else {
            IResource resource = agent.IAgent_getConfigurationResource();
            Assertion.wilyAssert(false);
            if (resource != null) {
                if (resource.IResource_isFileResource()) {
                    extensionDirectory = new ExtendedFile(new File(resource.IResource_getLocation()).getParent(), directoryProperty);
                } else {
                    this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Extension_Cannot_Use_Relative_Path_For_System_Resource"));
                }
            }
        }
        if (extensionDirectory != null && !extensionDirectory.exists()) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Not_Found", extensionDirectory.safeGetCanonicalPath()));
            extensionDirectory = null;
        }
        if (extensionDirectory != null && !extensionDirectory.isDirectory()) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Not_A_Directory", extensionDirectory.safeGetCanonicalPath()));
            extensionDirectory = null;
        }
        if (extensionDirectory != null) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Directory_Found", extensionDirectory.safeGetCanonicalPath()));
        }
        return extensionDirectory;
    }

    private final IExtensionLocator createExtensionLocator(IExtensionLocatorPolicy policy, ExtendedFile extensionDirectory) {
        IExtensionLocator locator = null;
        locator = extensionDirectory != null ? policy.createExtensionLocator(this.getModuleFeedback(), this.getStringLocalizer(), extensionDirectory) : new NullExtensionLocator();
        return locator;
    }

    private final String getAttribute(IExtension extension, String attributeName, String defaultValue) {
        String result = extension.IExtension_getAttributes().getValue(attributeName);
        return result == null ? defaultValue : result;
    }

    private final void logExtensionVersions() {
        IExtension[] extensions = this.fBroker.IExtensionBroker_getFilteredExtensionList(kAgentExtensionType);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String extensionName = extension.IExtension_getName();
            String releaseString = this.getAttribute(extension, "com-wily-Release", "<Unknown Release>");
            String buildString = this.getAttribute(extension, "com-wily-Build", "<Unknown Build>");
            this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Release_And_Build", extensionName, releaseString, buildString));
            ++i;
        }
    }

    public final ExtendedFile getAgentExtensionDirectory() {
        return this.fAgentExtensionDirectory;
    }

    public final IPlugin[] getAgentPluginsByType(String pluginType) {
        return this.fBroker.IExtensionBroker_getFilteredPluginList(kAgentExtensionType, pluginType);
    }

    public void registerExtensionClassloaders(IsengardServerConnectionManager serverConn) {
        IExtension[] extensions = this.fBroker.IExtensionBroker_getFilteredExtensionList(kAgentExtensionType);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String key = extension.IExtension_getClassloaderKey();
            if (key != null && key.length() > 0) {
                serverConn.registerClassloader(key, extension.IExtension_getClassLoader());
            }
            ++i;
        }
    }
}

