/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;

public class ConcurrentInvocationCounter
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private final IIntegerFluctuatingCounterDataAccumulator fDataAccumulator = this.cacheDataAccumulator();

    public ConcurrentInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private final IIntegerFluctuatingCounterDataAccumulator cacheDataAccumulator() {
        if (this.canUseCaching()) {
            return this.createDataAccumulator(this.getFormattedName());
        }
        return null;
    }

    protected final IIntegerFluctuatingCounterDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    public boolean ITracerFactory_isShutoff() {
        if (this.fDataAccumulator != null) {
            return this.fDataAccumulator.IDataAccumulator_isShutOff();
        }
        return false;
    }

    public ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (this.fDataAccumulator != null) {
            return this;
        }
        IIntegerFluctuatingCounterDataAccumulator counter = this.createDataAccumulator(this.formatParameterizedName(data));
        if (data.storeConcurrentInovocationCounter(counter)) {
            return this;
        }
        return new Counter(counter);
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (this.fDataAccumulator != null) {
            this.fDataAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
        } else {
            IIntegerFluctuatingCounterDataAccumulator counter = data.retrieveConcurrentInvocationCounter();
            counter.IIntegerFluctuatingCounterDataAccumulator_increment();
        }
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.fDataAccumulator != null) {
            this.fDataAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
        } else {
            IIntegerFluctuatingCounterDataAccumulator counter = data.retrieveConcurrentInvocationCounter();
            counter.IIntegerFluctuatingCounterDataAccumulator_decrement();
        }
    }

    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    private static final class Counter
    implements ITracer {
        private final IIntegerFluctuatingCounterDataAccumulator fAccumulator;

        public Counter(IIntegerFluctuatingCounterDataAccumulator accumulator) {
            this.fAccumulator = accumulator;
        }

        public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
            this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
        }

        public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
            this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
        }
    }
}

