/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.AutoTracingClampHelper;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessCacheElementsLimit;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessDownstreamGuidClamp;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessUpstreamTimeout;
import com.wily.introscope.agent.trace.intelligent.CrossCorrelationUpstreamGuidsProvider;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.QueueMapCache;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HighPerformanceTransactionCache {
    public static String UPSTREAM_GUID_FILLER = "HighPerformanceTransactionCache.UPSTREAM_GUID_FILLER";
    private IAgent fAgent;
    AtomicInteger currentSize = new AtomicInteger(0);
    private static volatile HighPerformanceTransactionCache fInstance = null;
    ConcurrentLinkedQueue<HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> fHighPerformanceStacks;
    ConcurrentHashMap<String, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack> fGUIDToHighPerformanceStackMap;
    ConcurrentHashMap<String, AtomicInteger> fPerGuidCounter;
    ConcurrentLinkedQueue<String> fUpstreamTransactionGUIDs;
    AtomicBoolean fUpstreamQueueDirty = new AtomicBoolean(false);
    AtomicLong fUpstreamQueueTimestamp = new AtomicLong(0L);
    private List kEmptyList = new ArrayList();
    private QueueMapCache<String, Boolean> downtreamGUIDCache;

    public HighPerformanceTransactionCache(IAgent agent) {
        this.fAgent = agent;
        this.fHighPerformanceStacks = new ConcurrentLinkedQueue();
        this.fGUIDToHighPerformanceStackMap = new ConcurrentHashMap();
        this.fUpstreamTransactionGUIDs = new ConcurrentLinkedQueue();
        this.fPerGuidCounter = new ConcurrentHashMap();
        this.downtreamGUIDCache = new QueueMapCache();
        this.downtreamGUIDCache.initializeQueue(UPSTREAM_GUID_FILLER, AutotraceCrossprocessDownstreamGuidClamp.fValue);
        int i = 0;
        while (i < AutoTracingClampHelper.fClampLimit) {
            this.fUpstreamTransactionGUIDs.add(UPSTREAM_GUID_FILLER);
            ++i;
        }
    }

    public static HighPerformanceTransactionCache getInstance() {
        return fInstance;
    }

    public static void setInstance(HighPerformanceTransactionCache inst) {
        fInstance = inst;
        CrossCorrelationUpstreamGuidsProvider.setInstance(new CrossCorrelationUpstreamGuidsProvider(inst));
        fInstance.addCrossProcessUpstreamCallback();
    }

    private void addCrossProcessUpstreamCallback() {
        SharedCrossProcessData.addCrossProcessDataCallback(new SharedCrossProcessData.ICrossProcessDataCallBack(){

            @Override
            public void prepareOptionalParameters(SharedCrossProcessData data) {
                data.addParamOut("UpstreamGUIDCache", (ArrayList)CrossCorrelationUpstreamGuidsProvider.getInstance().getParam("UpstreamGUIDCache"));
            }
        });
    }

    public HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack checkout() {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = this.getNextFromQueue();
        String guid = stack.getTransactionGUID();
        if (guid != null) {
            String key = String.valueOf(guid) + stack.getPerDeepStackGuidIndex();
            this.fGUIDToHighPerformanceStackMap.remove(key);
            this.fPerGuidCounter.remove(guid);
            this.currentSize.addAndGet(-(stack.fStack.length / 9));
        }
        return stack;
    }

    public void checkin(String guid, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack) {
        stack.setInUse(false);
        AtomicInteger index = new AtomicInteger(0);
        AtomicInteger existingIndex = this.fPerGuidCounter.putIfAbsent(guid, index);
        if (existingIndex != null) {
            index = existingIndex;
        }
        int i = index.incrementAndGet();
        stack.setPerDeepStackGuidIndex(i);
        stack.setPerGuidCounterRef(index);
        String key = String.valueOf(guid) + i;
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Downstream agent added the GUID+counter " + key + " to downstream deepstack cache at: " + System.currentTimeMillis());
        }
        this.fGUIDToHighPerformanceStackMap.put(key, stack);
        this.fHighPerformanceStacks.add(stack);
        this.currentSize.addAndGet(stack.fStack.length / 9);
        SustainabilityMetricsHelper.reportCachedTransactionCountSustainabilityMetrics(1);
    }

    public void addToQueue(List<String> listOfGuids) {
        if (listOfGuids != null) {
            for (String guid : listOfGuids) {
                this.downtreamGUIDCache.addToQueue(guid, true);
                if (!CrossProcessLogger.isDebugEnabled()) continue;
                CrossProcessLogger.logDebugMessage("Downstream agent added the GUID " + guid + " to downstream guid cache");
            }
        }
    }

    public QueueMapCache<String, Boolean> getDownStreamGUIDCache() {
        return this.downtreamGUIDCache;
    }

    public HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] getForTransactionTrace(String guid) {
        AtomicInteger counter;
        String key = String.valueOf(guid) + 1;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = this.fGUIDToHighPerformanceStackMap.get(key);
        if (stack != null && (counter = stack.getPerGuidCounterRef()) != null) {
            int count = counter.get();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] stackArr = new HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[count];
            int i = 0;
            while (i < count) {
                key = String.valueOf(guid) + (i + 1);
                stack = this.fGUIDToHighPerformanceStackMap.get(key);
                if (stack == null || !stack.trySetInUse(true)) {
                    int j = 0;
                    while (j < i) {
                        stackArr[j].trySetInUse(false);
                        ++j;
                    }
                    return null;
                }
                stackArr[i] = stack;
                ++i;
            }
            return stackArr;
        }
        return null;
    }

    public boolean GUIDToHighPerformanceStackMapContainsGUID(String guid) {
        return this.fGUIDToHighPerformanceStackMap.contains(guid);
    }

    public void resetStackUse(String guid, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack) {
        if (stack != null) {
            stack.trySetInUse(false);
        }
    }

    private HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack getNextFromQueue() {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack stack = null;
        boolean bSuccess = false;
        while (!bSuccess) {
            if (stack != null) {
                this.fHighPerformanceStacks.add(stack);
            }
            if (this.currentSize.get() < AutotraceCrossprocessCacheElementsLimit.fValue) {
                stack.fTopStackElement.fStack = stack = new HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack();
                stack.fExceptionElement.fStack = stack;
                stack.prevElement.fStack = stack;
                stack.poppedElement.fStack = stack;
                stack.fMaxResponseTimeElement.fStack = stack;
            } else {
                stack = this.fHighPerformanceStacks.poll();
            }
            if (stack == null) continue;
            bSuccess = stack.trySetInUse(true);
        }
        return stack;
    }

    public void addUpstreamGUID(String txGuid) {
        if (CrossProcessLogger.isDebugEnabled()) {
            CrossProcessLogger.logDebugMessage("Upstream agent added the GUID " + txGuid + " to upstream cache");
        }
        this.fUpstreamTransactionGUIDs.add(txGuid);
        this.fUpstreamTransactionGUIDs.poll();
        this.fUpstreamQueueDirty.set(true);
        this.fUpstreamQueueTimestamp.set(System.currentTimeMillis());
        SustainabilityMetricsHelper.reportUpstreamGuidCountSustainabilityMetrics(1);
    }

    public boolean isDirty() {
        return this.fUpstreamQueueDirty.get();
    }

    public List getUpstreamGuids() {
        if (this.isDirty()) {
            if (System.currentTimeMillis() - this.fUpstreamQueueTimestamp.get() > (long)AutotraceCrossprocessUpstreamTimeout.fValue || !CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled()) {
                int i = 0;
                while (i < AutoTracingClampHelper.fClampLimit) {
                    this.fUpstreamTransactionGUIDs.add(UPSTREAM_GUID_FILLER);
                    this.fUpstreamTransactionGUIDs.poll();
                    ++i;
                }
                this.fUpstreamQueueDirty.set(false);
                return this.kEmptyList;
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] guids = this.fUpstreamTransactionGUIDs.toArray(new String[0]);
            StringBuffer strBuff = new StringBuffer();
            if (CrossProcessLogger.isDebugEnabled() && guids.length > AutoTracingClampHelper.fClampLimit) {
                CrossProcessLogger.logDebugMessage("Upstream agent GUID list exceeds clamp size :" + guids.length);
            }
            int count = 0;
            int i = guids.length - 1;
            while (i >= 0) {
                if (guids[i] != UPSTREAM_GUID_FILLER) {
                    if (CrossProcessLogger.isDebugEnabled()) {
                        strBuff.append(guids[i]);
                    }
                    if (++count > AutoTracingClampHelper.fClampLimit) break;
                    list.add(guids[i]);
                }
                --i;
            }
            if (CrossProcessLogger.isDebugEnabled()) {
                CrossProcessLogger.logDebugMessage("Upstream agent sending GUID list " + strBuff.toString() + " to downstream cache");
            }
            return list;
        }
        return this.kEmptyList;
    }
}

