/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.CanonicalObjectPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class BoundaryOnlyTransactionData
extends TransactionComponentData {
    private static final long serialVersionUID = -8762718901468459490L;
    private static final String kBatchHeaderResourceName = "BundledTrace";
    private static int sMaxCalledComponents = 10000;

    public BoundaryOnlyTransactionData() {
    }

    public BoundaryOnlyTransactionData(BoundaryOnlyTransactionData[] bundledTransactions, HashMap params) {
        this(kBatchHeaderResourceName, params, bundledTransactions);
    }

    public BoundaryOnlyTransactionData(String resource, HashMap params, BoundaryOnlyTransactionData[] calledComponents) {
        super(resource, params, calledComponents);
        this.pruneNullValues();
    }

    private void pruneNullValues() {
        if (this.getSubNodes() == null) {
            this.setSubNodes(new BoundaryOnlyTransactionData[0]);
        }
    }

    public void setParameters(HashMap param) {
        super.setParameters(param);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public void writeInternal(DataOutput out) throws IOException {
        LinkedList<BoundaryOnlyTransactionData> stack = new LinkedList<BoundaryOnlyTransactionData>();
        stack.addLast(this);
        do {
            BoundaryOnlyTransactionData current = (BoundaryOnlyTransactionData)stack.removeLast();
            BoundaryOnlyTransactionData[] children = this.writeSelf(current, out);
            int i = children.length - 1;
            while (i >= 0) {
                stack.addLast(children[i]);
                --i;
            }
        } while (!stack.isEmpty());
    }

    protected void readInternal(DataInput in) throws IOException {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addLast(this);
        do {
            Object top;
            if ((top = stack.removeLast()) instanceof TTCalledComponentData) {
                BoundaryOnlyTransactionData child;
                int index;
                TTCalledComponentData children = (TTCalledComponentData)top;
                ++children.fNextIndex;
                BoundaryOnlyTransactionData[] calledComponents = children.fCalledComponents;
                if (index >= calledComponents.length) continue;
                calledComponents[index] = child = new BoundaryOnlyTransactionData();
                stack.addLast(children);
                stack.addLast(child);
                continue;
            }
            if (!(top instanceof BoundaryOnlyTransactionData)) continue;
            BoundaryOnlyTransactionData current = (BoundaryOnlyTransactionData)top;
            TTCalledComponentData children = new TTCalledComponentData();
            children.fCalledComponents = this.realizeSelf(current, in);
            stack.addLast(children);
        } while (!stack.isEmpty());
    }

    public BoundaryOnlyTransactionData[] writeSelf(BoundaryOnlyTransactionData data, DataOutput out) throws IOException {
        out.writeUTF(data.getResource());
        out.writeInt(data.getParameters().size());
        Iterator iterator = data.getParameters().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            out.writeUTF((String)entry.getKey());
            if (entry.getValue() != null) {
                out.writeUTF(BoundaryOnlyTransactionData.clampString4WriteUTF((String)entry.getValue()));
                continue;
            }
            out.writeUTF("");
        }
        out.writeInt(data.getSubNodeCount());
        if (data.getSubNodeCount() == 0) {
            return new BoundaryOnlyTransactionData[0];
        }
        return (BoundaryOnlyTransactionData[])data.getSubNodes();
    }

    protected BoundaryOnlyTransactionData[] realizeSelf(BoundaryOnlyTransactionData self, DataInput in) throws IOException {
        self.setResource(CanonicalObjectPool.getCanonicalString(in.readUTF()));
        int parameterCount = in.readInt();
        if (parameterCount == 0) {
            self.setParameters(kNoParameters);
        } else {
            self.setParameters(new HashMap(parameterCount));
        }
        int i = 0;
        while (i < parameterCount) {
            String key = CanonicalObjectPool.getCanonicalString(in.readUTF());
            String value = CanonicalObjectPool.getCanonicalString(in.readUTF());
            self.getParameters().put(key, value);
            ++i;
        }
        int calledComponentCount = in.readInt();
        if (calledComponentCount == 0) {
            self.setSubNodes(new BoundaryOnlyTransactionData[0]);
        } else {
            if (calledComponentCount > sMaxCalledComponents) {
                throw new RuntimeException("Received too big BoundaryOnlyTransactionData with " + calledComponentCount + " called components exceeding max allowed: " + sMaxCalledComponents);
            }
            self.setSubNodes(new BoundaryOnlyTransactionData[calledComponentCount]);
        }
        return (BoundaryOnlyTransactionData[])self.getSubNodes();
    }

    protected static class TTCalledComponentData {
        public BoundaryOnlyTransactionData[] fCalledComponents;
        public int fNextIndex;

        protected TTCalledComponentData() {
        }
    }
}

