/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace.weblogic;

import com.wily.introscope.spec.server.transactiontrace.ACrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.ICrossProcessData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WeblogicCrossProcessData
extends ACrossProcessData
implements ICrossProcessData {
    private byte[] data;
    private String correlationID;
    private int seqNo;
    private int markedForReporting;
    private static Class weblogicTraceClass = null;
    private static WeblogicTraceReflectionHelper helper = null;
    public static final String kWeblogicTraceClassName = "weblogic.trace.Trace";
    static /* synthetic */ Class class$0;

    private WeblogicCrossProcessData(String correlationID, int seqNo, int markedForReporting) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        WeblogicCrossProcessData.writeStream(stream, new StreamData(correlationID, seqNo, markedForReporting));
        this.data = stream.toByteArray();
        this.correlationID = correlationID;
        this.seqNo = seqNo;
        this.markedForReporting = markedForReporting;
    }

    public static WeblogicCrossProcessData getCurrentCrossProcessData(IModuleFeedbackChannel feedback) {
        WeblogicCrossProcessData result = null;
        if (weblogicTraceClass != null && helper != null) {
            try {
                byte[] b = helper.currentTrace();
                if (b != null && b.length > 0) {
                    try {
                        StreamData data = WeblogicCrossProcessData.readStream(new ByteArrayInputStream(b));
                        result = new WeblogicCrossProcessData(data.correlationID, data.seqNo, data.markedForReporting);
                    }
                    catch (IOException ioe) {
                        feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                        feedback.debug(ioe);
                    }
                }
            }
            catch (NoSuchMethodException nsme) {
                feedback.error(nsme);
                feedback.debug(nsme);
            }
            catch (InvocationTargetException ite) {
                feedback.error(ite);
                feedback.debug(ite);
            }
            catch (IllegalAccessException iae) {
                feedback.error(iae);
                feedback.debug(iae);
            }
            catch (ClassCastException cce) {
                feedback.error(cce);
                feedback.debug(cce);
            }
        }
        return result;
    }

    public static WeblogicCrossProcessData createCrossProcessData(IModuleFeedbackChannel feedback) {
        WeblogicCrossProcessData result = null;
        if (weblogicTraceClass != null) {
            try {
                StreamData data = new StreamData(GUIDGenerator.getInstance().generateKey(), 0, 0);
                WeblogicCrossProcessData cpData = new WeblogicCrossProcessData(data.correlationID, data.seqNo, data.markedForReporting);
                helper.beginTrace(cpData.data);
                result = cpData;
            }
            catch (IOException ioe) {
                feedback.error(ioe);
                feedback.debug(ioe);
            }
            catch (NoSuchMethodException nsme) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(nsme);
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ite);
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(iae);
            }
        }
        return result;
    }

    public static void setWeblogicTracerClass(Class traceClass) {
        weblogicTraceClass = traceClass;
        try {
            helper = new WeblogicTraceReflectionHelper(traceClass);
        }
        catch (Exception exception) {
            weblogicTraceClass = null;
            helper = null;
        }
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public int getSequence() {
        return this.seqNo;
    }

    public int getReportingMark() {
        return this.markedForReporting;
    }

    public void incrementCrossProcessData(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        if (weblogicTraceClass != null) {
            try {
                WeblogicCrossProcessData newData = new WeblogicCrossProcessData(currentData.getCorrelationID(), currentData.getSequence() + 1, currentData.getReportingMark());
                helper.propagateTrace(newData.data);
            }
            catch (IOException ioe) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ioe);
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ite);
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(iae);
            }
        }
    }

    public void decrementCrossProcessData(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        if (weblogicTraceClass != null) {
            try {
                WeblogicCrossProcessData newData = new WeblogicCrossProcessData(currentData.getCorrelationID(), currentData.getSequence() - 1, currentData.getReportingMark());
                helper.propagateTrace(newData.data);
                if (newData.seqNo == 0) {
                    helper.endTrace();
                }
            }
            catch (IOException ioe) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ioe);
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ite);
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(iae);
            }
        }
    }

    public static boolean isWeblogicAppServerContext(IModuleFeedbackChannel feedback) {
        boolean result = weblogicTraceClass != null;
        return result;
    }

    private static void writeStream(ByteArrayOutputStream stream, StreamData data) throws IOException {
        stream.write(data.correlationID.length());
        stream.write(data.correlationID.getBytes());
        stream.write(data.seqNo);
        stream.write(data.markedForReporting);
    }

    private static StreamData readStream(ByteArrayInputStream stream) throws IOException {
        int stringLen = stream.read();
        byte[] idBytes = new byte[stringLen];
        if (stream.read(idBytes, 0, stringLen) != stringLen) {
            throw new IOException("Corrupted correlation ID in trace data");
        }
        int seqNo = stream.read();
        int markedForReporting = stream.read();
        return new StreamData(new String(idBytes), seqNo, markedForReporting);
    }

    public String toString() {
        return "[WLXPData: corr=" + this.correlationID + ", seq=" + this.seqNo + ", markedForReporting=" + this.markedForReporting + "]";
    }

    public boolean isMarkedForSympatheticCrossJVMTracing() {
        return this.markedForReporting != 0;
    }

    public void markForSympatheticCrossJVMTracing(ICrossProcessData currentData, IModuleFeedbackChannel feedback) {
        if (weblogicTraceClass != null) {
            try {
                this.markedForReporting = 1;
                WeblogicCrossProcessData newData = new WeblogicCrossProcessData(currentData.getCorrelationID(), currentData.getSequence(), 1);
                helper.propagateTrace(newData.data);
            }
            catch (IOException ioe) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ioe);
            }
            catch (InvocationTargetException ite) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(ite);
            }
            catch (IllegalAccessException iae) {
                feedback.error("A minor error occurred attempting to access cross-JVM data.  The error has been handled and will not cause and adverse effects.");
                feedback.debug(iae);
            }
        }
    }

    private static class StreamData {
        String correlationID;
        int seqNo;
        int markedForReporting;

        StreamData(String correlationID, int seqNo, int markedForReporting) {
            this.correlationID = correlationID;
            this.seqNo = seqNo;
            this.markedForReporting = markedForReporting;
        }
    }

    private static class WeblogicTraceReflectionHelper {
        private Method fBeginTrace;
        private Method fEndTrace;
        private Method fPropagateTrace;
        private Method fCurrentTrace;
        private static final String kBeginTrace = "beginTrace";
        private static final String kEndTrace = "endTrace";
        private static final String kPropagateTrace = "propagateTrace";
        private static final String kCurrentTrace = "currentTrace";
        private static final Class[] kEmptySignature = new Class[0];
        private static final Class[] kByteArraySignature;
        private static final Object[] kEmptyArgs;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            kByteArraySignature = classArray;
            kEmptyArgs = new Object[0];
        }

        WeblogicTraceReflectionHelper(Class traceClass) throws NoSuchMethodException {
            this.fBeginTrace = traceClass.getDeclaredMethod(kBeginTrace, kByteArraySignature);
            this.fEndTrace = traceClass.getDeclaredMethod(kEndTrace, kEmptySignature);
            this.fPropagateTrace = traceClass.getDeclaredMethod(kPropagateTrace, kByteArraySignature);
            this.fCurrentTrace = traceClass.getDeclaredMethod(kCurrentTrace, kEmptySignature);
        }

        byte[] beginTrace(byte[] traceArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Object[] args = new Object[]{traceArgs};
            byte[] bytes = (byte[])this.fBeginTrace.invoke(null, args);
            return bytes;
        }

        byte[] endTrace() throws IllegalAccessException, InvocationTargetException {
            byte[] bytes = (byte[])this.fEndTrace.invoke(null, kEmptyArgs);
            return bytes;
        }

        void propagateTrace(byte[] traceArgs) throws IllegalAccessException, InvocationTargetException {
            Object[] args = new Object[]{traceArgs};
            this.fPropagateTrace.invoke(null, args);
        }

        byte[] currentTrace() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            return (byte[])this.fCurrentTrace.invoke(null, kEmptyArgs);
        }
    }
}

