/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;

public abstract class AGatherer
implements IGatherer {
    private int fESETypeCookie;
    private long fGatherStartTimestampInMillis;
    private boolean fDataPresent;
    private boolean fIsNewData;
    private int fMetricDataRemovedInterval;
    private int fMetricExplosionNumberOfTimeSlicesForRemoval = 180000;

    protected AGatherer(int typeCookie, long startTimestamp) {
        this.fESETypeCookie = typeCookie;
        this.fGatherStartTimestampInMillis = startTimestamp;
        this.fMetricDataRemovedInterval = 0;
    }

    public final int getESETypeCookie() {
        return this.fESETypeCookie;
    }

    public final long getStartTimestampInMillis() {
        return this.fGatherStartTimestampInMillis;
    }

    protected final void resetStartTimestamp(long newTimestamp) {
        this.fGatherStartTimestampInMillis = newTimestamp;
    }

    public final synchronized void acceptAggregateTimeslicedValue(ATimeslicedValue newAggregate) throws IncompatibleTypesException {
        if (newAggregate != null && !newAggregate.dataIsAbsent()) {
            this.doAcceptAggregateTimeslicedValue(newAggregate);
            this.noteDataIsPresent();
        }
    }

    public final void acceptValueNonSync(IMetricDataValue value) throws IncompatibleTypesException {
        if (!value.dataIsAbsent()) {
            this.doAcceptAggregateTimeslicedValue(value);
            this.fDataPresent = true;
        }
    }

    protected final boolean isDataPresent() {
        return this.fDataPresent;
    }

    protected final boolean isDataAbsent() {
        return !this.fDataPresent;
    }

    protected final void noteDataIsPresent() {
        this.fDataPresent = true;
    }

    protected final void noteDataIsAbsent() {
        this.fDataPresent = false;
    }

    public final synchronized ATimeslicedValue[] harvestAndReset(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] results = this.harvest(when, blameStack);
        this.reset(when);
        return results;
    }

    public IMetricDataValue harvestAndReinitializeNonSync(long harvestTimeMS) {
        ATimeslicedValue[] result = this.harvest(harvestTimeMS, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        this.reset(harvestTimeMS);
        this.noteDataIsAbsent();
        return result[0];
    }

    public IMetricDataValue harvestAndAbandonNonSync(long harvestTimeMS) {
        ATimeslicedValue[] result = this.harvest(harvestTimeMS, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        return result[0];
    }

    protected final ATimeslicedValue[] harvest(long when, BlameStackSnapshot blameStack) {
        this.changeMetricDataState();
        return this.doHarvest(when, blameStack);
    }

    protected final void reset(long when) {
        this.doReset(when);
    }

    public final synchronized void reinitialize() {
        this.doReinitialize();
        this.noteDataIsAbsent();
    }

    protected final void reinitializeNonSync() {
        this.doReinitialize();
        this.noteDataIsAbsent();
    }

    protected abstract void doAcceptAggregateTimeslicedValue(IMetricDataValue var1) throws IncompatibleTypesException;

    protected abstract ATimeslicedValue[] doHarvest(long var1, BlameStackSnapshot var3);

    protected abstract void doReset(long var1);

    protected abstract void doReinitialize();

    public String toString() {
        return "type: 0x" + Integer.toHexString(this.fESETypeCookie) + " absent: " + this.isDataAbsent() + " starttime: " + this.getStartTimestampInMillis();
    }

    public final ATimeslicedValue[] IGatherer_harvestAndReset(long when) {
        return this.harvestAndReset(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }

    public final ATimeslicedValue[] IGatherer_harvestAndReset(long when, BlameStackSnapshot blameStack) {
        return this.harvestAndReset(when, blameStack);
    }

    public final synchronized ATimeslicedValue[] IGatherer_harvest(long when) {
        return this.harvest(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }

    public final synchronized ATimeslicedValue[] IGatherer_harvest(long when, BlameStackSnapshot blameStack) {
        return this.harvest(when, blameStack);
    }

    public final synchronized void IGatherer_reset(long when) {
        this.reset(when);
    }

    public final void IGatherer_acceptAggregateTimeslicedValue(ATimeslicedValue newAggregate) throws IncompatibleTypesException {
        this.acceptAggregateTimeslicedValue(newAggregate);
    }

    public final void IGatherer_reinitialize() {
        this.reinitialize();
    }

    public final int IGatherer_getESETypeCookie() {
        return this.getESETypeCookie();
    }

    public boolean IGatherer_canCombineData() {
        return false;
    }

    public void forceToExist(BlameStackSnapshot blameStack) {
        this.noteDataIsPresent();
    }

    public void changeMetricDataState() {
        if (this.fIsNewData) {
            if (this.fMetricDataRemovedInterval > 0) {
                this.fMetricDataRemovedInterval = 0;
            }
            this.fIsNewData = false;
        } else {
            ++this.fMetricDataRemovedInterval;
        }
    }

    public boolean IGatherer_hasNewData(int timeslices) {
        if (timeslices != this.fMetricExplosionNumberOfTimeSlicesForRemoval) {
            this.fMetricExplosionNumberOfTimeSlicesForRemoval = timeslices;
        }
        return this.fIsNewData || this.fMetricDataRemovedInterval <= this.fMetricExplosionNumberOfTimeSlicesForRemoval;
    }

    public long IGatherer_getStartTimestamp() {
        return this.getStartTimestampInMillis();
    }

    protected final void newDataPointsReceived() {
        if (!this.fIsNewData) {
            this.fIsNewData = true;
        }
    }
}

