/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.ongoingquery;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.callback.ICallbackConnectorCloseNotification;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.ongoingquery.AQueryNotification;
import com.wily.isengard.ongoingquery.IQueriable;
import com.wily.isengard.ongoingquery.IQueryMatch;
import com.wily.isengard.ongoingquery.QueryID;
import com.wily.isengard.ongoingquery.QueryNotificationConnector;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.exception.UnexpectedExceptionError;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractQueryServiceManager {
    private final PostOffice po;
    private int id = 0;

    protected AbstractQueryServiceManager(PostOffice po) {
        this.po = po;
    }

    protected abstract void runNotification(Runnable var1);

    protected abstract Map getQueries();

    public abstract void acquireReadStateLock() throws InterruptedException;

    public abstract void releaseReadStateLock();

    public abstract void acquireWriteStateLock() throws InterruptedException;

    public abstract void releaseWriteStateLock();

    public QueryID addOngoingQuery(IQueriable query, AQueryNotification notification) throws EndpointNotFoundException {
        OngoingQuery ongoingQuery = new OngoingQuery(this.po, notification, query);
        Collection matches = query.matchState();
        this.runNotification(new NotifyAdded(ongoingQuery, matches, true));
        return ongoingQuery.getQueryID();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryID addOngoingQuery2(IQueriable query, AQueryNotification notification) throws EndpointNotFoundException {
        OngoingQuery ongoingQuery = null;
        try {
            this.acquireReadStateLock();
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
        try {
            ongoingQuery = new OngoingQuery(this.po, notification, query);
        }
        catch (Throwable throwable) {
            Object e = null;
            this.releaseReadStateLock();
            throw throwable;
        }
        {
            Object e = null;
            this.releaseReadStateLock();
            Collection matches = query.matchState();
            this.runNotification(new NotifyAdded(ongoingQuery, matches, true));
            return ongoingQuery.getQueryID();
        }
    }

    private synchronized QueryID getNewID() {
        return new QueryID(++this.id);
    }

    private void registerOngoingQuery(OngoingQuery ongoingQuery) {
        this.getQueries().put(ongoingQuery.getQueryID(), ongoingQuery);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeOngoingQuery(QueryID queryID) {
        try {
            this.acquireReadStateLock();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            this.getQueries().remove(queryID);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.releaseReadStateLock();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.releaseReadStateLock();
            return;
        }
    }

    public int getNumQueries() {
        return this.getQueries().size();
    }

    public void stateAdded(Object[] stateData) {
        if (stateData.length == 0) {
            return;
        }
        Iterator it = this.getQueries().values().iterator();
        while (it.hasNext()) {
            OngoingQuery query = (OngoingQuery)it.next();
            Collection matches = query.getQuery().matchAddedState(stateData);
            if (matches.isEmpty()) continue;
            this.runNotification(new NotifyAdded(query, matches, false));
        }
    }

    public void stateRemoved(Object[] stateData) {
        if (stateData.length == 0) {
            return;
        }
        Iterator it = this.getQueries().values().iterator();
        while (it.hasNext()) {
            OngoingQuery query = (OngoingQuery)it.next();
            Collection matches = query.getQuery().matchRemovedState(stateData);
            if (matches.isEmpty()) continue;
            this.runNotification(new NotifyRemoved(query, matches));
            Collection moreMatches = query.getQuery().matchState();
            if (moreMatches.isEmpty()) continue;
            try {
                query.getMatchInterface().dataAdded(moreMatches);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    public void stateChanged(Object[] stateData) {
        if (stateData.length == 0) {
            return;
        }
        Iterator it = this.getQueries().values().iterator();
        while (it.hasNext()) {
            OngoingQuery query = (OngoingQuery)it.next();
            Collection matches = query.getQuery().matchChangedState(stateData);
            if (matches.isEmpty()) continue;
            this.runNotification(new NotifyChanged(query, matches));
        }
    }

    private void closeQuery(OngoingQuery query) {
        this.removeOngoingQuery(query.getQueryID());
    }

    private class NotifyAdded
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;
        private final boolean initialMatchesFinished;

        public NotifyAdded(OngoingQuery notify, Collection state, boolean initialMatchesFinished) {
            this.notify = notify;
            this.state = state;
            this.initialMatchesFinished = initialMatchesFinished;
        }

        public void run() {
            try {
                if (!this.state.isEmpty()) {
                    this.notify.getMatchInterface().dataAdded(this.state);
                }
                if (this.initialMatchesFinished) {
                    this.notify.getMatchInterface().initialMatchesFinished();
                }
            }
            catch (ConnectionException connectionException) {}
        }
    }

    private class NotifyChanged
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;

        public NotifyChanged(OngoingQuery notify, Collection state) {
            this.notify = notify;
            this.state = state;
        }

        public void run() {
            try {
                this.notify.getMatchInterface().dataChanged(this.state);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    private class NotifyRemoved
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;

        public NotifyRemoved(OngoingQuery notify, Collection state) {
            this.notify = notify;
            this.state = state;
        }

        public void run() {
            try {
                this.notify.getMatchInterface().dataRemoved(this.state);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    protected final class OngoingQuery
    implements ICallbackConnectorCloseNotification {
        private final QueryID queryID;
        private final IQueriable query;
        private final QueryNotificationConnector connector;

        public OngoingQuery(PostOffice po, AQueryNotification notification, IQueriable query) throws EndpointNotFoundException {
            this.queryID = AbstractQueryServiceManager.this.getNewID();
            this.query = query;
            AbstractQueryServiceManager.this.registerOngoingQuery(this);
            try {
                this.connector = new QueryNotificationConnector(po, notification, this);
            }
            catch (EndpointNotFoundException t) {
                AbstractQueryServiceManager.this.removeOngoingQuery(this.queryID);
                throw t;
            }
        }

        public void close() {
            this.connector.close();
        }

        public IQueriable getQuery() {
            return this.query;
        }

        public QueryID getQueryID() {
            return this.queryID;
        }

        public void closing(CallbackConnector which) {
            AbstractQueryServiceManager.this.closeQuery(this);
        }

        public IQueryMatch getMatchInterface() {
            return (IQueryMatch)this.connector.getInterface();
        }
    }
}

