/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.CustomRulesFactory;
import com.wily.introscope.agent.intelligent.entrypoint.rules.IsAppClassRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.IsInBottomNPercentRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.IsInterestingMethodNameRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.MatchesSourceFileExtRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipClassRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipMarkedForSkipInsRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipMethodIfAlreadyInstrumentedRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipMethodNameRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipPackageRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.SkipTopNPercentRule;
import java.util.LinkedHashSet;
import java.util.Set;

public class RulesSettings {
    private static volatile Set<Rule> defaultRules = null;

    private static Set<Rule> createDefaultRulesSet(IAgent agent) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>(EntryPointDetectionConfiguration.getMaxRules());
        Set<String> skipPkgs = EntryPointDetectionConfiguration.getEssentialPackagesToSkip();
        Set<String> additionalSkipPkgs = EntryPointDetectionConfiguration.getAdditionalPackagesToSkip();
        if (additionalSkipPkgs.size() > 0) {
            skipPkgs.addAll(additionalSkipPkgs);
        }
        rules.add(new SkipPackageRule(skipPkgs, false));
        Set<String> skipMethodRegexps = EntryPointDetectionConfiguration.getMethodsToSkip();
        rules.add(new SkipMethodNameRule(skipMethodRegexps));
        rules.add(new SkipClassRule(".*\\$\\d+.*"));
        rules.add(new MatchesSourceFileExtRule(".java"));
        rules.add(new SkipMarkedForSkipInsRule(agent));
        rules.add(new SkipTopNPercentRule(EntryPointDetectionConfiguration.getSkipTopPercentOfStackTrace()));
        rules.add(CustomRulesFactory.createRuleToSkipNativeMethod());
        rules.add(new SkipMethodIfAlreadyInstrumentedRule(agent));
        Set<String> methodNameRegexps = EntryPointDetectionConfiguration.getInterestingMethodNames();
        rules.add(new IsInterestingMethodNameRule(methodNameRegexps));
        Set<String> appPackages = EntryPointDetectionConfiguration.getApplicationPackages();
        if (appPackages.size() > 0) {
            rules.add(new IsAppClassRule(appPackages));
        }
        rules.add(CustomRulesFactory.createRuleToSelectChildOfCall());
        rules.add(CustomRulesFactory.createRuleToSelectFirstNonJavaElement());
        rules.add(new IsInBottomNPercentRule(EntryPointDetectionConfiguration.getIncludeBottomPercentOfStackTrace()));
        return rules;
    }

    static Set<Rule> getDefaultRulesSet(IAgent agent) {
        if (defaultRules == null) {
            defaultRules = RulesSettings.createDefaultRulesSet(agent);
        }
        return defaultRules;
    }

    public static Set<Rule> getCopyOfDefaultRulesSet(IAgent agent) {
        LinkedHashSet<Rule> rules = new LinkedHashSet<Rule>();
        rules.addAll(RulesSettings.getDefaultRulesSet(agent));
        return rules;
    }
}

