/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.rules;

import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.entrypoint.rules.AbstractRule;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CustomRulesFactory {
    private static volatile Set<Pattern> patternsOfPackagesToSkip = null;

    public static Rule createRuleToSelectChildOfCall() {
        return new AbstractRule(){
            private Set<Pattern> skipPkgPatterns = new HashSet<Pattern>(CustomRulesFactory.access$0());
            private Set<String> callerMethods = new HashSet<String>(CustomRulesFactory.access$1());

            @Override
            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                IndexAwareTraceElement traceElement = trace[currentElementIndex];
                if (!Utils.doesElementPackageMatch(traceElement, this.skipPkgPatterns) && !this.callerMethods.contains(traceElement.getMethodName())) {
                    return this.isCallerSpecialMethod(currentElementIndex + 1, trace);
                }
                return false;
            }

            private boolean isCallerSpecialMethod(int callerIndex, IndexAwareTraceElement[] trace) {
                if (callerIndex < 0 || callerIndex >= trace.length) {
                    return false;
                }
                IndexAwareTraceElement callerElement = trace[callerIndex];
                if (Utils.doesElementPackageMatch(callerElement, this.skipPkgPatterns)) {
                    return false;
                }
                return this.callerMethods.contains(callerElement.getMethodName());
            }

            @Override
            public String toString() {
                return Utils.formatStringRep("SelectChildOfNonJavaCallOrRunMethodRule, callerMethods:" + this.callerMethods);
            }
        };
    }

    public static Rule createRuleToSelectFirstNonJavaElement() {
        return new AbstractRule(){
            private Set<Pattern> skipPkgPatterns = new HashSet<Pattern>(CustomRulesFactory.access$0());

            @Override
            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                IndexAwareTraceElement traceElement = trace[currentElementIndex];
                if (!Utils.doesElementPackageMatch(traceElement, this.skipPkgPatterns)) {
                    return this.areAncestorsNonJavaElements(currentElementIndex, trace);
                }
                return false;
            }

            private boolean areAncestorsNonJavaElements(int currentElementIndex, IndexAwareTraceElement[] trace) {
                int parentIndex = currentElementIndex + 1;
                if (parentIndex >= trace.length || parentIndex < 0) {
                    return true;
                }
                IndexAwareTraceElement parentElement = trace[parentIndex];
                if (Utils.doesElementPackageMatch(parentElement, this.skipPkgPatterns)) {
                    return this.areAncestorsNonJavaElements(parentIndex, trace);
                }
                return false;
            }

            @Override
            public String toString() {
                return Utils.formatStringRep("SelectFirstNonJavaElementRule, skipPkgPatterns:" + this.skipPkgPatterns);
            }
        };
    }

    public static Rule createRuleToSkipNativeMethod() {
        return new AbstractFailFastRule(){

            @Override
            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                return !trace[currentElementIndex].isNativeMethod();
            }

            @Override
            public String toString() {
                return Utils.formatStringRep("SkipNativeMethodRule");
            }
        };
    }

    private static Set<String> getSpecialCallerMethodNames() {
        HashSet<String> specialMethods = new HashSet<String>();
        String[] stringArray = "call,run".split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            specialMethods.add(str);
            ++n2;
        }
        return specialMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<Pattern> getPatternsForEssentialPackagesToSkip() {
        Set<Pattern> patterns = patternsOfPackagesToSkip;
        if (patterns != null) return patterns;
        Class<CustomRulesFactory> clazz = CustomRulesFactory.class;
        synchronized (CustomRulesFactory.class) {
            patterns = patternsOfPackagesToSkip;
            if (patterns != null) return patterns;
            HashSet<Pattern> packagesPatterns = new HashSet<Pattern>();
            Set<String> packagesToSkip = EntryPointDetectionConfiguration.getEssentialPackagesToSkip();
            if (packagesToSkip == null) return patterns;
            for (String pkg : packagesToSkip) {
                pkg = Utils.convertToPackageRegex(pkg);
                packagesPatterns.add(Pattern.compile(pkg, 2));
            }
            patternsOfPackagesToSkip = packagesPatterns;
            return patternsOfPackagesToSkip;
        }
    }

    static /* synthetic */ Set access$0() {
        return CustomRulesFactory.getPatternsForEssentialPackagesToSkip();
    }

    static /* synthetic */ Set access$1() {
        return CustomRulesFactory.getSpecialCallerMethodNames();
    }
}

