/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.rules;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.CandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.rules.AbstractFailFastRule;
import com.wily.introscope.agent.transformer.dynamic.ITracerProviderService;
import com.wily.introscope.autoprobe.AutoProbeTransformer;

public class SkipMethodIfAlreadyInstrumentedRule
extends AbstractFailFastRule {
    int fClassFileSizeLimit = Integer.MAX_VALUE;
    private IIntelligentInstrumentationTracerHelper fHelper = null;
    private ITracerProviderService fTracerProvider = null;
    private IAgent agent = null;

    public SkipMethodIfAlreadyInstrumentedRule(IAgent agent) {
        this.agent = agent;
        this.fHelper = agent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
    }

    public SkipMethodIfAlreadyInstrumentedRule(AutoProbeTransformer autoProbeTransformer) {
        this.agent = autoProbeTransformer.getAgent();
        this.fHelper = autoProbeTransformer.getAgent().IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        if (CandidateFinder.allClassesInVm == null) {
            return true;
        }
        if (this.fHelper != null) {
            String methodName;
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String className = traceElement.getClassName();
            boolean result = this.fHelper.areMatchingMethodsTraced(className, methodName = traceElement.getMethodName(), CandidateFinder.allClassesInVm);
            return !result;
        }
        return true;
    }

    @Override
    public String toString() {
        return Utils.formatStringRep(this.getClass().getSimpleName());
    }
}

