/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.ThreadSelector;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.probebuilder.extension.instrument.intelligent.IntelligentInstrumentationService;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceRecordingController {
    private static volatile int maxRecordingsPerInterval = 5;
    private static final AtomicInteger numberRecordings = new AtomicInteger(0);
    private static final ThreadSelector threadSelector = ThreadSelector.getInstance();

    public static boolean shouldRecordStackTrace() {
        if (IntelligentInstrumentationService.isMaskSet(127)) {
            return false;
        }
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        if (threadLocalDeepStack.isFrontendCandidateMarked()) {
            return false;
        }
        if (numberRecordings.get() >= maxRecordingsPerInterval) {
            return false;
        }
        if (!threadSelector.shouldRecordTrace(threadLocalDeepStack)) {
            return false;
        }
        if (StackTraceRecordingController.hasFrontEndMarker(threadLocalDeepStack)) {
            return false;
        }
        return numberRecordings.incrementAndGet() <= maxRecordingsPerInterval;
    }

    private static boolean hasFrontEndMarker(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        return threadLocalDeepStack.hasFrontend();
    }

    private static boolean isThreadTraced(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack) {
        return threadLocalDeepStack.isMyTracingOn();
    }

    public static void notifyRecordingListeners() {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack threadLocalDeepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        threadSelector.notifyOnRecording(threadLocalDeepStack);
    }

    public static int getRecordingsCount() {
        return numberRecordings.get();
    }

    public static void resetRecordingsCounter() {
        numberRecordings.set(0);
    }

    public static void setStackTracesLimitPerInterval(int limit) {
        maxRecordingsPerInterval = limit;
    }
}

