/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;

public final class WrappedStackTraceElement
implements IndexAwareTraceElement {
    private final StackTraceElement actualTraceElement;
    private final int index;
    private final int sizeOfStackTrace;
    private static final String EMPTY_PACKAGE = "";
    private static final String PACKAGE_SEPARATOR = ".";

    public WrappedStackTraceElement(StackTraceElement traceElement, int index, int sizeOfStackTrace) {
        this.actualTraceElement = traceElement;
        this.index = index;
        this.sizeOfStackTrace = sizeOfStackTrace;
    }

    public String getFileName() {
        if (this.actualTraceElement != null) {
            return this.actualTraceElement.getFileName();
        }
        return null;
    }

    public int getLineNumber() {
        if (this.actualTraceElement != null) {
            return this.actualTraceElement.getLineNumber();
        }
        return 0;
    }

    public String getPackageName() {
        return WrappedStackTraceElement.findPackage(this.getClassName());
    }

    public String getClassName() {
        if (this.actualTraceElement != null) {
            return this.actualTraceElement.getClassName();
        }
        return null;
    }

    public String getMethodName() {
        if (this.actualTraceElement != null) {
            return this.actualTraceElement.getMethodName();
        }
        return null;
    }

    public boolean isNativeMethod() {
        if (this.actualTraceElement != null) {
            return this.actualTraceElement.isNativeMethod();
        }
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSizeOfMyStackTrace() {
        return this.sizeOfStackTrace;
    }

    public StackTraceElement getStackTraceElement() {
        return this.actualTraceElement;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexAwareTraceElement)) {
            return false;
        }
        IndexAwareTraceElement e = (IndexAwareTraceElement)obj;
        return e.getStackTraceElement().equals(this.actualTraceElement) && e.getIndex() == this.getIndex() && e.getSizeOfMyStackTrace() == this.getSizeOfMyStackTrace();
    }

    public int hashCode() {
        return this.actualTraceElement.hashCode() + this.index + this.sizeOfStackTrace;
    }

    public String toString() {
        return Utils.formatStringRep(String.valueOf(this.actualTraceElement.toString()) + ", index: " + this.index + ", size: " + this.sizeOfStackTrace);
    }

    public static String findPackage(String className) {
        int index = className.lastIndexOf(PACKAGE_SEPARATOR);
        String packageName = index <= -1 ? EMPTY_PACKAGE : className.substring(0, index);
        return packageName;
    }
}

