/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.tracers.EntryPointDetectionHelperTracer;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public final class DatagramReceiveEntryPointDetectionHelperTracer
extends EntryPointDetectionHelperTracer
implements ITracer {
    public DatagramReceiveEntryPointDetectionHelperTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(0) instanceof ByteBuffer && data.hasMethodResultAvailable()) {
            InetSocketAddress remoteAddress;
            DatagramChannel channel = (DatagramChannel)invocationObject;
            Object result = data.getInvocationReturnValueAsObject();
            if (result != null && result instanceof InetSocketAddress && DatagramChannelMap.isClientConnection((DatagramChannel)channel, (InetSocketAddress)(remoteAddress = (InetSocketAddress)result))) {
                this.suggestStackTraceRecording();
            }
        }
    }
}

