/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.introscope.probebuilder.instrumentation.IInstrumentationDecider;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.ByteCodeParser;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.IParser;
import com.wily.introscope.probebuilder.lexer.ByteCodeLexer;
import com.wily.introscope.probebuilder.scoring.MethodScorer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.HashMap;
import java.util.Map;

public class IntelligentInstrumentationDecider
implements IInstrumentationDecider {
    private IModuleFeedbackChannel fLog = IntelligentInstrumentationConfig.INSTANCE.getModuleFeedbackChannel();
    private ByteCodeLexer fLexer;
    private IParser fParser;
    protected Map<String, Object> fDecisionParameters;
    private Module fModule = IntelligentInstrumentationConfig.INSTANCE.getIntelligentInstrumentationModule();

    public IntelligentInstrumentationDecider() {
        this.fDecisionParameters = new HashMap<String, Object>();
        MethodScorer scorer = new MethodScorer();
        this.fDecisionParameters.put("METHOD_SCORE", scorer);
        this.fDecisionParameters.put("DECISION_MADE", false);
        this.fDecisionParameters.put("INSTRUMENTATION_DECISION", false);
        this.fLexer = new ByteCodeLexer(this.fDecisionParameters);
        this.fParser = new ByteCodeParser(this.fLexer);
        this.fParser.setDecisionParameters(this.fDecisionParameters);
    }

    public int getMethodScore(DGCode dgCode) {
        block2: {
            this.fLexer.reinit(dgCode);
            this.fParser.reinit(this.fLexer);
            try {
                this.fParser.start();
            }
            catch (Exception e) {
                if (!this.fLog.isDebugEnabled()) break block2;
                this.fLog.debug(this.fModule, this.fLexer.getMethodArtifacts(), (Throwable)e);
            }
        }
        return ((MethodScorer)this.fDecisionParameters.get("METHOD_SCORE")).getCurrentScore();
    }

    public boolean passesInstrumentationCriterion(DGCode dgCode) {
        dgCode.getCodeBytes();
        this.logMethodDecisionArtifacts(dgCode);
        return this.fParser.passesInstrumentationCriterion();
    }

    private boolean isLargeMethod(byte[] methodByteCode) {
        int maxMethodSizeValue = IntelligentInstrumentationConfig.INSTANCE.getMaxMethodSize();
        return methodByteCode.length > maxMethodSizeValue;
    }

    private void logMethodDecisionArtifacts(DGCode fDgCode) {
        if (!this.fLog.isTraceEnabled(this.fModule)) {
            return;
        }
        int methodScore = ((MethodScorer)this.fDecisionParameters.get("METHOD_SCORE")).getCurrentScore();
        String methodName = this.getMethodName(fDgCode);
        this.fLog.trace(this.fModule, "Token stream for: " + methodName + this.fLexer.getTokenStream());
        this.fLog.trace(this.fModule, "Method Score for: " + methodName + methodScore);
    }

    private String getMethodName(DGCode dgCode) {
        String methodName = String.valueOf(dgCode.getMethod().getMethodName().getNameAndSignatureString()) + "[ " + dgCode.getMethod().getDGClass().getClassName().getPackageAndNameString() + " ]";
        return methodName;
    }

    public Map<String, Object> getDecisionParameters() {
        return this.fDecisionParameters;
    }
}

