/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.wldf.IWLDFDataView;
import com.wily.introscope.agent.wldf.IntWLDFDataView;
import com.wily.introscope.agent.wldf.LongWLDFDataView;
import com.wily.introscope.agent.wldf.StringWLDFDataView;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class DataViewFactory {
    static final int kIntViewType = 1;
    static final int kLongViewType = 2;
    static final int kStringViewType = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public static IWLDFDataView createView(IAgent agent, ObjectName mbeanName, String wldfAttributeType, String wldfAttributeName, MBeanServer server, String fullIntroscopeMetricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (wldfAttributeType == null) {
            return new StringWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
        }
        int viewType = DataViewFactory.getViewType(wldfAttributeType);
        switch (viewType) {
            case 1: {
                return new IntWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
            }
            case 2: {
                return new LongWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
            }
        }
        return new StringWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
    }

    public static int getViewType(String inputType) {
        String type = inputType.replace('/', '.');
        if (DataViewFactory.isLongType(type)) {
            return 2;
        }
        if (DataViewFactory.isIntType(type)) {
            return 1;
        }
        return 3;
    }

    private static boolean isLongType(String type) {
        block20: {
            block19: {
                if (type.equals(Long.TYPE.getName())) break block19;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz.getName()) || type.equals(Double.TYPE.getName())) break block19;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz2.getName()) || type.equals(Float.TYPE.getName())) break block19;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz3.getName())) break block19;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!type.equals(clazz4.getName())) break block20;
            }
            return true;
        }
        return false;
    }

    private static boolean isIntType(String type) {
        block16: {
            block15: {
                if (type.equals(Short.TYPE.getName())) break block15;
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz.getName()) || type.equals(Integer.TYPE.getName())) break block15;
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type.equals(clazz2.getName()) || type.equals(Byte.TYPE.getName())) break block15;
                Class<?> clazz3 = class$6;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$6 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!type.equals(clazz3.getName())) break block16;
            }
            return true;
        }
        return false;
    }
}

