/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.lockable.ILockableFileContent;
import com.wily.util.properties.lockable.ILockableProfileWriter;
import com.wily.util.properties.lockable.IPropertyChangeEventNotifier;
import com.wily.util.properties.lockable.LockableFileManager;
import com.wily.util.properties.lockable.Profile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProfileWriter
implements Runnable,
ILockableProfileWriter,
ILockableFileContent {
    private final Object fRendezvous = new Object();
    private final LockableFileManager fManager;
    private Map fProperties = null;
    private Map fPropertiesIn = new HashMap();
    private boolean fShutdown = false;
    private boolean fProfileChange = false;
    private IPropertyChangeEventNotifier fNotifier;

    public ProfileWriter(LockableFileManager manager, IPropertyChangeEventNotifier notifier) {
        this.fNotifier = notifier;
        this.fManager = manager;
    }

    public ProfileWriter(LockableFileManager manager) {
        this(manager, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileChanged(Map propertyIntrinsics) {
        Object object = this.fRendezvous;
        synchronized (object) {
            this.fProfileChange = true;
            this.fPropertiesIn.putAll(propertyIntrinsics);
            this.fRendezvous.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.fRendezvous;
        synchronized (object) {
            this.fShutdown = true;
            this.fRendezvous.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean exit;
        do {
            boolean writeNeeded = false;
            exit = false;
            try {
                Object object = this.fRendezvous;
                synchronized (object) {
                    while (!this.fProfileChange && !this.fShutdown) {
                        this.fRendezvous.wait();
                    }
                    writeNeeded = this.fProfileChange;
                    exit = this.fShutdown;
                    this.fProperties = new HashMap(this.fPropertiesIn);
                    this.fPropertiesIn.clear();
                    this.fProfileChange = false;
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (!writeNeeded) continue;
            this.sendPropertyChangeEvents(this.fProperties, this.fManager.writeLockableFile(this));
        } while (!exit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeContent(ExtendedFile file) throws IOException {
        Profile profile;
        block8: {
            block7: {
                BufferedReader in = null;
                profile = null;
                try {
                    in = new BufferedReader(new FileReader(file.getFile()));
                    profile = Profile.read(in);
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                {
                    Object var4_8 = null;
                    if (in == null) break block7;
                }
                in.close();
            }
            BufferedWriter out = null;
            try {
                profile.update(this.fProperties);
                out = new BufferedWriter(new FileWriter(file.getFile()));
                profile.write(out);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (out != null) {
                    out.close();
                }
                if (profile == null) throw throwable;
                profile.clear();
                throw throwable;
            }
            {
                Object var5_6 = null;
                if (out == null) break block8;
            }
            out.close();
        }
        if (profile == null) return;
        profile.clear();
    }

    private void sendPropertyChangeEvents(Map properties, boolean success) {
        if (this.fNotifier != null) {
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String newValueString = me.getValue().toString();
                if (success) {
                    this.fNotifier.sendSuccessfulPropertyChangeEvent((String)me.getKey(), newValueString);
                    continue;
                }
                this.fNotifier.sendFailedPropertyChangeEvent((String)me.getKey(), newValueString);
            }
        }
    }
}

