/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.sysview.namefilter;

import com.wily.introscope.ext.sysview.common.Messages;
import com.wily.introscope.ext.sysview.common.SysViewConstants;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;

public class PSBNameTracerFilter
extends ATransactionTraceFilter
implements Externalizable,
SysViewConstants {
    private String mName;

    public String getMName() {
        return this.mName;
    }

    public PSBNameTracerFilter() {
        this.mName = "";
    }

    public PSBNameTracerFilter(String name) {
        this.mName = name;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mName = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    private void writeInternal(DataOutput out) throws IOException {
        out.writeUTF(this.mName);
    }

    public int ITransactionTraceFilter_getFilterType() {
        return 186;
    }

    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Generic_Filter_Description_Message", this.ITransactionTraceFilter_getLocalizedStatusMessage(localizer));
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        String statusMessage = "";
        if (this.mName != null && !this.mName.equalsIgnoreCase("")) {
            statusMessage = Messages.getString("SysviewFilter.PSBNameFilterStatusMessage", this.mName);
        }
        return statusMessage;
    }

    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        String statusMessage = "";
        if (this.mName != null && !this.mName.equalsIgnoreCase("")) {
            statusMessage = Messages.getString(locale, "SysviewFilter.PSBNameFilterStatusMessage", this.mName);
        }
        return statusMessage;
    }

    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    public boolean isHeadFilter() {
        return true;
    }

    public boolean shouldCollect(Map params) {
        String SysviewPSBNameValue = (String)params.get(Messages.getString("TT_SysViewPSBNameFilter_Key"));
        if (SysviewPSBNameValue == null || SysviewPSBNameValue.length() == 0) {
            return false;
        }
        return SysviewPSBNameValue.equalsIgnoreCase(this.mName);
    }

    public boolean ITransactionTraceFilter_passesFilter(IEventDataNode root) {
        Map params;
        boolean passes = false;
        if (root != null && !(passes = this.shouldCollect(params = root.getParameters()))) {
            int indexc = root.getSubNodeCount() - 1;
            while (!passes && indexc >= 0) {
                passes = this.ITransactionTraceFilter_passesFilter(root.getSubNode(indexc));
                --indexc;
            }
        }
        return passes;
    }

    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        Map params;
        boolean passes = false;
        if (root != null && !(passes = this.shouldCollect(params = root.getParameters()))) {
            int indexc = root.getSubNodeCount() - 1;
            while (!passes && indexc >= 0) {
                passes = this.ITransactionTraceFilter_passesFilter(root.getSubNode(indexc));
                --indexc;
            }
        }
        return passes;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PSBNameTracerFilter) {
            PSBNameTracerFilter filter = (PSBNameTracerFilter)obj;
            return this.mName.equals(filter.mName);
        }
        return false;
    }
}

